<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use DataTables, URL, DB;
use App\Models\Question;
use Illuminate\Http\Request;
use App\Models\Classification;
use App\Models\Pratice_Question;
use App\Models\Pratice_Leaderborad;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class Classification_Controller extends Controller
{

    public function index()
    {
        try {
            return view('admin.classification.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add()
    {
        try {
            return view('admin.classification.add');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request)
    {
        try {
            $validator = Validator::make($request->all(),[
                'level_name' => 'required|min:2',
                'level_order' => 'required'
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $user = new Classification();
                $user->level_name = $request->level_name;
                $user->level_order = $request->level_order;

                if($user->save())
                {
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_classification')));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_classification')));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {
        try{
            if ($request==true) {
                $data = Classification::select('*');

                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("editClassification",$row->id).'" class="btn"><img src="'.url("assets/imgs/edit.png").'" /></a> ';
                    $btn .= '<a href="'.route("deleteClassification",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
            } else{     
                return view('admin.classification.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try {
            $data = Classification::where('id',$id)->first();
            $question = Question::where('question_level_master_id',$id)->first();
            $pratice_question = Pratice_Question::where('question_level_master_id',$id)->first();
            $pratice_leaderborad = Pratice_Leaderborad::where('question_level_master_id','$id')->first();

            if ($question !== null) {
                return back()->with('error', __('Label.This Classification is used on some other table so you can not remove it.'));
            } elseif ($pratice_leaderborad !== null) {
                return back()->with('error', __('Label.This Classification is used on some other table so you can not remove it.')); 
            } elseif ($pratice_question !== null) {
                return back()->with('error', __('Label.This Classification is used on some other table so you can not remove it.')); 
            } else {
                if($data->delete()){
                    return back()->with('error', __('Classification Delete Successfully.')); 
                }
            }            
        } catch(Exception $e) {
            return redirect('classification')->with($e);
        }
    }
    public function edit(Request $request,$id)
    {
        try {
            $user = Classification::where('id',$id)->first();
            return view('admin.classification.edit',['result'=>$user]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
        try{
            $validator = Validator::make($request->all(),[
                'level_name' => 'required|min:2',
                'level_order' => 'required'
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $user = Classification::where('id',$request->id)->first();

                if (isset($user->id)) {
                    $user->level_name = $request->level_name;
                    $user->level_order = $request->level_order;
                    if($user->save()){
                        return response()->json(array('status' => 200,'success'=> __('Label.success_edit_classification')));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=>__('Label.error_edit_classification')));
                    }
                }
            }
        } catch(Exception $e){
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
}

