<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use App\Models\Level;
use App\Models\Contest;
use DataTables, URL, DB;
use App\Models\Question;
use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class ContestQuestionController extends Controller
{

    private $folder = "/question";

    public function index()
    {   
        try{
            return view('admin.contest_question.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add()
    {
        try{
            $category = Category::select('*')->get();
            $contest = Contest::select('*')->get();
            return view('admin.contest_question.add',['category'=>$category, 'contest'=>$contest]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request)
    {   
        try{
            if($request->question_type == 2){
                $validator = Validator::make($request->all(),[
                    'category_id' => 'required',
                    'contest_id' => 'required',
                    'question' => 'required',
                    'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'question_type' => 'required',
                    'option_a' => 'required',
                    'option_b' => 'required',
                    'answer' => 'required',
                    'note' => 'required',
                ]);
            } else {
                $validator = Validator::make($request->all(),[
                    'category_id' => 'required',
                    'contest_id' => 'required',
                    'question' => 'required',
                    'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'question_type' => 'required',
                    'option_a' => 'required',
                    'option_b' => 'required',
                    'option_c' => 'required',
                    'option_d' => 'required',
                    'answer' => 'required',
                    'note' => 'required',
                ]);
            }
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                
                $question = new Question();
                $question->category_id = $request->category_id;
                $question->contest_id = $request->contest_id;
                $question->level_id = 0;        
                $question->question = $request->question;
                $question->question_type = $request->question_type;
                $question->option_a = $request->option_a;
                $question->option_b = $request->option_b;
                if($request->question_type == 1){
                    $question->option_c = $request->option_c;
                    $question->option_d = $request->option_d;
                } else {
                    $question->option_c = "";
                    $question->option_d = "";
                }
                $question->answer = $request->answer;
                $question->note = $request->note;        

                $org_name = $request->file('image');
                if ($org_name) {
                    $question->image = saveImage($org_name,$this->folder);
                }

                if($question->save()){
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_question')));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_question')));
                }
            }
        } catch(Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {   
        try{
            if ($request==true) {

                $data = Question::with('category')
                        ->where('level_id',0)
                        ->get();

                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("editContestquestion",$row->id).'" class="btn"><img src="'.url("assets/imgs/edit.png").'" /></a> ';
                    $btn .= '<a href="'.route("deleteContestquestion",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /> </a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
            } else{     
                return view('admin.user.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try{
            $question = Question::where('id',$id)->first();
            if ($question->image) {
                if($question->delete()){
                    @unlink("images/question/".$question->image);        
                    return back()->with('success', __('Label.Contest Question Delete Successfully.'));  
                }
            } else {
                if($question->delete()){
                    return back()->with('success', __('Label.Contest Question Delete Successfully.'));  
                }
            }
        } catch(Exception $e){
            return redirect('contestquestion')->with($e);
        }
    }
    public function edit(Request $request,$id)
    {
        try{
            $question = Question::where('id',$id)->first();
            $category = Category::select('name','id')->get();
            $contest = Contest::select('*')->get();
            return view('admin.contest_question.edit',['result'=>$question, 'category'=>$category, 'contest'=>$contest]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
        try{
            if($request->question_type == 2){
                $validator = Validator::make($request->all(),[
                    'category_id' => 'required',
                    'contest_id' => 'required',
                    'question' => 'required',
                    'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'question_type' => 'required',
                    'option_a' => 'required',
                    'option_b' => 'required',
                    'answer' => 'required',
                    'note' => 'required',
                ]);
            } else {
                $validator = Validator::make($request->all(),[
                    'category_id' => 'required',
                    'contest_id' => 'required',
                    'question' => 'required',
                    'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'question_type' => 'required',
                    'option_a' => 'required',
                    'option_b' => 'required',
                    'option_c' => 'required',
                    'option_d' => 'required',
                    'answer' => 'required',
                    'note' => 'required',
                ]);
            }
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $question = Question::where('id',$request->id)->first();

                if (isset($question->id)) {

                    $question->category_id = $request->category_id;
                    $question->contest_id = $request->contest_id;
                    $question->level_id = 0;        
                    $question->question = $request->question;
                    $question->question_type = $request->question_type;
                    $question->option_a = $request->option_a;
                    $question->option_b = $request->option_b;
                    if($request->question_type == 2){
                        $question->option_c = "";
                        $question->option_d = "";
                    }else {
                        $question->option_c = $request->option_c;
                        $question->option_d = $request->option_d;
                    }
                    $question->answer = $request->answer;
                    $question->note = $request->note;

                    $org_name = $request->file('image');
                    if ($org_name) {
                        $question->image = saveImage($org_name,$this->folder);
                        @unlink("images/question/".$request->old_image);         
                    } else {
                        $question->image = $request->old_image;                    
                    }

                    if($question->save()){
                        return response()->json(array('status' => 200, 'success'=> __('Label.success_edit_question')));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=> __('Label.error_edit_question')));
                    }
                }
            }
        } catch(Exception $e){
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    
}
