<?php

namespace App\Http\Controllers\Api;

use Validator;
use App\Models\Level;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Models\Classification;
use App\Models\Pratice_Question;
use App\Models\QuestioLeaderboard;
use App\Http\Controllers\Controller;

class Level_Controller extends Controller
{
    public function get_level(Request $request)
    {   
        try {
            $validator = Validator::make($request->all(), [
                'category_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $level = Level::orderBy('level_order','asc')->get();
                $category = category::get();

                if ($level){
                    $size = sizeof($level);

                    $result['status'] = 200;
                    $result['message'] = __('api_msg.get_record_successfully');
                    foreach ($category as $key => $value) {
                        if($value->id == $request->category_id){
                            $result['result'] = $level;
                            for ($i = 0; $i < $size; $i++) {
                                $level[$i]->category_id = $value->id;
                                if($i == 0){
                                    $level[$i]->is_unlock = 1;
                                    $lock = Question_Is_unlock($request->user_id, $request->category_id, $level[$i]->id);
                                    if ($lock && $lock->correct_answers >= $lock->win_question_count ){
                                        if($i+1 < $size){
                                            $level[$i]->is_unlock = 1;
                                            $level[$i+1]->is_unlock = 1;
                                        }
                                    } else {
                                        if($i+1 < $size){
                                            $level[$i+1]->is_unlock = 0;
                                        }
                                    }
                                } else {
                                    $lock = Question_Is_unlock($request->user_id, $request->category_id, $level[$i]->id);
                                    if ($lock && $lock->correct_answers >= $lock->win_question_count ){
                                        if($i+1 < $size){
                                            $level[$i]->is_unlock = 1;
                                            $level[$i+1]->is_unlock = 1;
                                        }
                                    } else {
                                        if($i+1 < $size){
                                            $level[$i+1]->is_unlock = 0;
                                        }
                                    }
                                } 
                            }
                            break;
                        } else {
                            $result['result'] = [];
                        }
                    }
                    return $result;
                } else {
                    $result['status'] = 200;
                    $result['message'] = __('api_msg.get_record_successfully');
                    $result['result'] = [];
                    return $result;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function get_pratice_level(Request $request)
    {
        try {
            $level = Level::orderBy('level_order','asc')->get();
            if ($level){
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = $level;
                return $result;
            } else {
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = [];
                return $result;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function getQuestionLevelMaster()
    {
        try {
            $data = Classification::all();
            if ($data) {
                $level_master['status'] = 200;
                $level_master['message'] = __('api_msg.get_record_successfully');
                $level_master['result'] = $data;
                return $level_master;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.no_record');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function category()
    {
        try {
            $category = Category::get();
            if ($category) {
                $size = sizeof($category);
                for ($i = 0; $i < $size; $i++) {

                    $path = url('images/category/' . $category[$i]->image);
                    $category[$i]->image = $path;
                }
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = $category;
                return $result;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.record_not_found');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function getCategoryByLevelMaster(Request $request)
    {   
        try {
            $validator = Validator::make($request->all(), [
                'question_level_master_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $question_level_master_id = $request->question_level_master_id;
                
                $data = Pratice_Question::select('category_id')
                    ->where('question_level_master_id',$question_level_master_id)
                    ->groupBy('category_id')
                    ->get();
                if(count($data)){
                    foreach ($data as $key => $value) {
                        if($value->category->image){
                            $path = url('images/category/' . $value->category->image);
                            $value->category->image = $path;          
                        } else {
                            $value->category->image = "";          
                        }
                        $category[] = $value->category;
                    }
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.get_record_successfully');
                    $msg['result'] = $category;
                } else {
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.get_record_successfully');
                    $msg['result'] = [];
                }
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    
    public function getLavelByCategoryId(Request $request)
    {   
        try {
            $validator = Validator::make($request->all(), [
                'category_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $level = Level::orderBy('level_order','asc')->get();
                $category = category::get();

                if (count($level) && count($category)){
                    $size = sizeof($level);

                    $result['status'] = 200;
                    $result['message'] = __('api_msg.get_record_successfully');
                    foreach ($category as $key => $value) {
                        if($value->id == $request->category_id){
                            $result['result'] = $level;
                            for ($i = 0; $i < $size; $i++) {
                                $level[$i]->category_id = $value->id;
                                if($i == 0){
                                    $level[$i]->is_unlock = 1;
                                    $lock = Question_Is_unlock($request->user_id, $request->category_id, $level[$i]->id);
                                    if ($lock && $lock->correct_answers >= $lock->win_question_count ){
                                        if($i+1 < $size){
                                            $level[$i]->is_unlock = 1;
                                            $level[$i+1]->is_unlock = 1;
                                        }
                                    } else {
                                        if($i+1 < $size){
                                            $level[$i+1]->is_unlock = 0;
                                        }
                                    }
                                } else {
                                    $lock = Question_Is_unlock($request->user_id, $request->category_id, $level[$i]->id);
                                    if ($lock && $lock->correct_answers >= $lock->win_question_count ){
                                        if($i+1 < $size){
                                            $level[$i]->is_unlock = 1;
                                            $level[$i+1]->is_unlock = 1;
                                        }
                                    } else {
                                        if($i+1 < $size){
                                            $level[$i+1]->is_unlock = 0;
                                        }
                                    }
                                } 
                            }
                            break;
                        } else {
                            $result['result'] = [];
                        }
                    }
                    return $result;
                } else {
                    $result['status'] = 200;
                    $result['message'] = __('api_msg.get_record_successfully');
                    $result['result'] = [];
                    return $result;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

}
