<?php

namespace App\Http\Controllers\Api;

use Validator;
use App\Models\Notification;
use Illuminate\Http\Request;
use App\Models\Notification_Tracking;
use App\Http\Controllers\Controller;

class Notification_Controller extends Controller
{

    public function get_notification(Request $request)
    {   
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $all_noti = Notification::all();
                $user_noti = Notification_Tracking::where('user_id', $request->user_id)->get();

                $arr = array();
                for ($i = 0; $i < count($user_noti); $i++) {
                    $arr[] = $user_noti[$i]->notification_id;
                }
                $data = Notification::select('*')->whereNotIn('id', $arr)->get();
                for ($i=0; $i < count($data) ; $i++) { 
                    if($data[$i]->big_picture){
                        $path = url('images/notification/' . $data[$i]->big_picture);
                        $data[$i]->big_picture = $path;
                    } else {
                        $data[$i]->big_picture = "";                        
                    }
                }
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = $data;
                return $result;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function read_notification(Request $request)
    {   
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'notification_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $noti = new Notification_Tracking();
                $noti->user_id = $request->user_id;
                $noti->notification_id = $request->notification_id;

                if ($noti->save()) {
                    $data['status'] = 200;
                    $data['message'] = __('api_msg.notification_read_by_user_successfully');
                    return $data;
                } else {
                    $data['status'] = 400;
                    $data['message'] = __('api_msg.notification_not_read_by_user_successfully');
                    return $data;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

}
