
<?php $__env->startSection('title', __('Label.Question')); ?>
<?php $__env->startSection('content'); ?>

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"> <?php echo $__env->yieldContent('title'); ?> </h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              <?php echo e(__('Label.Question')); ?>

            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="<?php echo e(route('questionAdd')); ?>" class="btn btn-default mw-150" style="margin-top:-14px"><?php echo e(__('Label.Add Question')); ?></a>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-striped question-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> <?php echo e(__('Label.Id')); ?> </th>
              <th> <?php echo e(__('Label.Question')); ?> </th>
              <th width="20px"> <?php echo e(__('Label.Question  Image')); ?></th>
              <th> <?php echo e(__('Label.Category')); ?> </th>
              <th> <?php echo e(__('Label.Level')); ?> </th>
              <th> <?php echo e(__('Label.Option A')); ?> </th>
              <th> <?php echo e(__('Label.Option B')); ?> </th>
              <th> <?php echo e(__('Label.Option C')); ?> </th>
              <th> <?php echo e(__('Label.Option D')); ?> </th>
              <th> <?php echo e(__('Label.Answer')); ?> </th>
              <th width="100px"> <?php echo e(__('Label.Action')); ?> </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.question-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          language: {
            paginate: {
              previous: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' >",
              next: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' style='transform: rotate(180deg)'>"
            }
          },
          order: [ [0, 'asc'] ],
          ajax: "<?php echo e(route('questionData')); ?>",
          columns: [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
          {data: 'question', name:'question'},
          { data: 'image', name: 'image', 
            "render": function (data, type, full, meta) {
              if(data) {
                return "<img src='<?php echo e(url('images/question/')); ?>/"+ data + "'  height=50 width=50 />";
              } else {
                return "<img src='<?php echo e(url('assets/imgs//1.png')); ?>' height=50 width=50 />";
              } 
            },
          },
          {data: 'category.name', name: 'category.name',
            "render": function (data, type, full, meta) {
              if(data) {
                return data;
              } else {
                return "-";
              }
            },
          },
          {data: 'level.name', name: 'levelname',
            "render": function (data, type, full, meta) {
              if(data) {
                return data;
              } else {
                return "-";
              }
            },
          },
          {data: 'option_a', name: 'option_a'},
          {data: 'option_b', name: 'option_b'},
          {data: 'option_c', name: 'option_c',
            "render": function (data, type, full, meta) {
            if (data) {
              return data;
            } else {
              return "-";
            }
            },
          },
          {data: 'option_d', name: 'option_d',
            "render": function (data, type, full, meta) {
            if (data) {
              return data;
            } else {
              return "-";
            }
            },
          },
          { data: 'answer', name: 'answer', 
            "render": function (data, type, full, meta) {

              if (data == 1) {
                return "A";
              } else if(data == 2){
                return "B";
              } else if(data == 3){
                return "C";
              } else if(data == 4){
                return "D";
              } else {
                return data;
              }
            },
          },
          {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\envato\app\dtquiz_backend\resources\views/admin/question_question/index.blade.php ENDPATH**/ ?>