<!DOCTYPE html>
<html lang="en">

  <head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>DTQuiz</title>

    <?php $app = URL::asset('/images/app').'/'.setting_app_logo()?>
    <link rel="shortcut icon" href="<?php echo e($app); ?>">
    
    <!-- Start: Css -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('/assets/css/toastr.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('/assets/css/style.css')); ?>" rel="stylesheet" type="text/css">
    <!-- End: Css -->
  </head>

  <body>
    <!-- Start: Content -->
    <div class="h-100">
    <div class="h-100 no-gutters row">
      <div class="d-none d-lg-block h-100 col-lg-5 col-xl-4">
          <div class="left-caption">
              <img src="<?php echo e(asset('assets/imgs/login.jpg')); ?>" class="bg-img" />
              <div class="caption">
                  <div>
                      <!-- <h3>Login</h3> -->
                      <!-- logo -->
                      <a href="#">
                          <img src="<?php echo e(asset('assets/imgs/DTQuiz.png')); ?>" alt="" class="img-fluid" width="50%"/>
                      </a>
                      <p class="text">
                          Lorem ipsum dolor sit amet consectetur adipisicing elit. Iusto quaerat fuga optio voluptatibus ullam
                          aliquam consectetur, quam, veritatis facilis dolor id perspiciatis distinctio ratione! Reprehenderit
                          rerum
                          provident vero praesentium molestiae?
                      </p>
                  </div>
              </div>
          </div>
      </div>
      <div class="h-100 d-flex login-bg justify-content-center align-items-lg-center col-md-12 col-lg-7 col-xl-8">
          <div class="mx-auto col-sm-12 col-md-10 col-xl-8">
              <div class="py-5 p-3">

                  <!-- logo -->
                  <div class="app-logo mb-4">
                      <a href="#" class="mb-4 d-block d-lg-none">
                          <img src="assets/imgs/logo.png" alt="" class="img-fluid" />
                      </a>
                      <h3 class="primary-color mb-0 font-weight-bold">Login</h3>
                  </div>
                  <!-- end logo -->

                  <h4 class="mb-0 font-weight-bold">
                      <span class="d-block mb-2">Welcome back,</span>
                      <span>Please sign in to your account.</span>
                  </h4>
                  <!-- <h6 class="mt-3 border-bottom pb-3">No account? <a href="javascript:void(0);" class="text-primary">Sign up
                      now</a></h6>
                  <div> -->
                  <form  id="save_login">
                      <?php echo csrf_field(); ?>
                      <div class="form-row mt-4">
                          <div class="col-md-6">
                              <div class="position-relative form-group">
                                  <label for="exampleEmail" class="">Email</label>
                                  <input name="email" id="email" placeholder="Email here..." type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="admin@admin.com" required autocomplete="email" autofocus>
                                  <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                  <span class="invalid-feedback" role="alert">
                                      <strong><?php echo e($message); ?></strong>
                                  </span>
                                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                              </div>
                          </div>
                          <div class="col-md-6">
                              <div class="position-relative form-group">
                                  <label for="examplePassword" class="">Password</label>
                                  <input name="password" id="password" placeholder="Password here..." type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="admin" required autocomplete="current-password">
                                  <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                  <span class="invalid-feedback" role="alert">
                                      <strong><?php echo e($message); ?></strong>
                                  </span>
                                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                              </div>
                          </div>
                      </div>
                      <div class="custom-control custom-checkbox mr-sm-2">
                          <input type="checkbox" class="custom-control-input" id="customControlAutosizing" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                          <label class="custom-control-label" for="customControlAutosizing">Keep me logged in</label>
                      </div>

                      <div class="form-row mt-4">
                          <div class="col-sm-6 text-center text-sm-left">
                              <button class="btn btn-default my-3 mw-120" onclick="save_login()" type="button">Login</button>
                          </div>
                            <!--<div class="col-sm-6 d-flex align-items-center justify-content-center justify-content-sm-end">
                              <a href="javascript:void(0);" class="btn-lg btn btn-link">Recover Password</a>
                            </div>-->
                      </div>

                      <!--  <div class="row mb-0">
                        <div class="col-md-8 offset-md-4">
                            <button type="submit" class="btn btn-primary">
                                <?php echo e(__('Login')); ?>

                            </button>

                            <?php if(Route::has('password.request')): ?>
                            <a class="btn btn-link" href="<?php echo e(route('password.request')); ?>">
                                <?php echo e(__('Forgot Your Password?')); ?>

                            </a>
                            <?php endif; ?>
                        </div>
                      </div>-->
                  </form>
              </div>
          </div>
      </div>
    </div>
</div>
    
</div>
    <!-- End: Content -->

    <!-- Start: Javascript -->
      <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/js/popper.min.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/bootstrap/js/bootstrap.min.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/js/jquery.dataTables.min.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/js/dataTables.bootstrap4.min.js')); ?>"></script>
      <script src="<?php echo e(asset('https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/js/js.js')); ?>"></script>
      <script src="<?php echo e(asset('/assets/js/toastr.min.js')); ?>"></script>
      <script>
        function get_responce_message(resp, form_name, url) {
          if (resp.status == '200') {
            toastr.success(resp.success);
            document.getElementById(form_name).reset();
            setTimeout(function () {
              window.location.replace(url);
            }, 500);
          } else {
            var obj = resp.errors;
            if (typeof obj === 'string') {
              toastr.error(obj);
            } else {
              $.each(obj, function (i, e) {
                toastr.error(e);
              });
            }
          }
        }
      </script>
      <script type="text/javascript">

        function save_login() {

          var formData = new FormData($("#save_login")[0]);

          $.ajax({
            type: 'POST',
            url: '<?php echo e(route("adminLoginPost")); ?>',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            success:function(resp){
              get_responce_message(resp, 'save_login', '<?php echo e(route("dashboard")); ?>');
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
              toastr.error(errorThrown.msg,'failed');         
            }

          });
        }
      </script>
      <script>
        $(document).ready(function() {
          <?php if(Session::has('error')): ?>
          toastr.error('<?php echo e(Session::get('error')); ?>');
          <?php elseif(Session::has('success')): ?>
          toastr.success('<?php echo e(Session::get('success')); ?>');
          <?php endif; ?>
        });
      </script>
    <!-- End: javascript -->
    
  </body>
</html>
<?php /**PATH D:\xampp\htdocs\envato\app\dtquiz_backend\resources\views/auth/login.blade.php ENDPATH**/ ?>