<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use App\Models\Pages;
use DataTables, URL, DB;
use App\Models\Withdrawal;
use App\Models\Transaction;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Pratice_Leaderborad;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class PagesController extends Controller
{
    private $folder = "/pages";

    public function index()
    {
        try{
            return view('admin.pages.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add()
    {
        try{
            return view('admin.pages.add');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request)
    {
        try {
            $validator = Validator::make($request->all(),[
              
                'content' => 'required',
                
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {

                $user = new Pages();
                $user->content = $request->content;
               
                

                if($user->save()){
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_user') ));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_user') ));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {
        try{
            if ($request==true) {
                $data = Pages::select('*');
                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("editPages",$row->id).'" class="btn"><img src="'.url("assets/imgs/edit.png").'" /></a> ';
                    $btn .= '<a href="'.route("deletePages",$row->id).'" id="'.$row->id.'" onclick="return archiveFunction(this.id)"  class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
            } else{     
                return view('admin.pages.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try {
           $user = Pages::where('id',$id)->first();
         

            
                if($user->delete()){
                    @unlink("images/user/".$user->profile_img);        
	                return back();
                }  
            
        } catch (Exception $e) {
            return redirect('user')->with($e);
        }
    }
    public function edit(Request $request,$id)
    {

       
        try{
            $user = Pages::where('id',$id)->first();
            if(isset($user->id)){
                return view('admin.pages.edit',['result'=>$user]);
            } else {
                return redirect()->route('home');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
       
        try {
         
                $user = Pages::where('id',$request->id)->first();
                if (isset($user->id)) {
                    $content = $request->content;   
                    libxml_use_internal_errors(true);
                   $dom = new \DomDocument();
                   $dom->encoding = 'utf-8';     
                   $dom->loadHtml( utf8_decode($content), LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD | libxml_use_internal_errors(true));
                   $imageFile = $dom->getElementsByTagName('img');
               
                   foreach($imageFile as $item => $image){
                       $data = $image->getAttribute('src');
                       if (strpos($data, ';') === false) {
                           continue;
                       }else{
                       list($type, $data) = explode(';', $data);
                       list(, $data)      = explode(',', $data);
                       $imgeData = base64_decode($data);
                       $image_name= "/images/" . time().$item.'.png';
                       $path = public_path() . $image_name;
                       file_put_contents($path, $imgeData);           
                       
                       $image->removeAttribute('src');
                       $image->setAttribute('src', URL('/').'/'.$image_name);
                   }
                       }
                       $content = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
               
                   $content .= $dom->saveHTML();
                   $data = $request->all();
           
                   $user->content=$content;

                               

                    if($user->save()){
                        return response()->json(array('status' => 200, 'success'=> __('Page Edited Succeesfully')));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=> __('Error editing page')));
                    }
                }
            
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

}
