<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\Controller;
use App\Exports\PraticeQuestionExport;
use App\Imports\PraticeQuestionImport;
use App\Exports\MttRegistrationsExport;

class PraticeQuestionImportController extends Controller
{

    public function index()
    {   
        try{
            return view('admin.pratice_question_import.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function export(Request $request)
    {
        try{
            return Excel::download(new PraticeQuestionExport, 'Data-Format-Pratice.csv');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function import(Request $request) 
    {   
        try{
            $validator = Validator::make($request->all(),[
                'import_file' => 'required|mimes:csv,txt',
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            }
            Excel::import(new PraticeQuestionImport, $request->file('import_file'));
            return response()->json(array('status' => 200, 'success'=> "File Upload Successfully" ));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
}
