<?php

namespace App\Http\Controllers\Admin;
use Illuminate\Support\Str as str;
use Validator;  
use DataTables, URL, DB;
use App\Models\Question;
use App\Models\Category;
use App\Models\StudySet;
use Illuminate\Http\Request;
use App\Models\Pratice_Question;
use App\Models\Sets;
use App\Models\Pratice_Leaderborad;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Services\PayUService\Exception;
use App\Models\MatchMaking;


class StudySetController extends Controller
{
    private $folder = "/studyset";
    
    public function index()
    {
        try {
            return view('admin.studyset.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add()
    {
        try {
            $category = Category::select('*')->get();
            return view('admin.studyset.add',['category'=>$category]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request)
    {
        try {
            if($request->reward_type == 3){
                $validator = Validator::make($request->all(),[
                    'name' => 'required|min:2',
                    'reward_type' => 'required',
                    'category_id'=>'required',
                    'status'=>'required',
                  
                ]);
            } else {
                $validator = Validator::make($request->all(),[
                    'name' => 'required|min:2',
                    'reward_type' => 'required',
                    'category_id'=>'required',
                    'reward_points'=>'required',
                    'max_userpoints'=>'required',
                    'status'=>'required',
                ]);
            }
         
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else{
                $user = new StudySet();
                $user->name = $request->name;
                $user->category_id = $request->category_id;
                $user->reward_type = $request->reward_type;
                $user->reward_points = $request->reward_points;
                $user->featured = $request->featured;
                $user->max_userpoints = $request->max_userpoints;
                $user->status = $request->status;
                $user->posted_by= Auth::id();

                $slug = str::slug($request->name, '-');
                $user->slug = $this->makeUniqueSlug($slug);
                // $org_name = $request->file('image');
                // $user->image = saveImage($org_name,$this->folder);
                $org_name = $request->file('cover_image');
                if ($org_name !=null) {
                    $user->cover_image = saveImage1($org_name,$this->folder,1);
                }
                $org_name = $request->file('main_image');
                if ($org_name !=null) {
                    $user->main_image = saveImage1($org_name,$this->folder,2);
                }
                $org_name = $request->file('icon_image');
                if ($org_name !=null) {
                    $user->icon_image = saveImage1($org_name,$this->folder,3);
                }
                if($user->save()){
                    $exists = DB::table('views_studysets')->where('studyset_id', $user->id)->exists();

                    if (!$exists) {
                        $data = [
                            'studyset_id' =>  $user->id,
                         
                            // Add more columns and values as needed
                        ];
                        
                        // Insert the record
                        DB::table('views_studysets')->insert($data);
                    }                  
                    
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_studyset') ));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_studyset')));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {
        try {
            if ($request==true) {
                $data = StudySet::select('*')->with('category')->with('user');
                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('reward_type', function($row){
                            
                    return ($row->reward_type==1 ) ? 'Primary' :( $row->reward_type==2 ? 'Secondary' : 'None') ;
                })
                ->addColumn('user_name', function($row){
                            
                    return ($row->user) ? $row->user->name :'None' ;
                })
                ->addColumn('category_name', function($row){
                            
                    return ($row->category) ? $row->category->name :'None' ;
                })
                ->addColumn('name', function($row){
                    $btn = '<a href="'.route("sets",$row->id).'" class="btn">'.$row->name.' </a> ';                  
                    return $btn;
                })
                ->editColumn('status', function($user) {
                    if($user->status == '0'){
                        $status = '<span class="badge badge-danger">'.__('Inactive').'</span>';
                    }else{
                        $status = '<span class="badge badge-success">'.__('Active').'</span>';
                    }
                    return $status;
                })
             
                ->editColumn('is_featured' , function ($category){
                    if($category->featured == '0'){
                        $featured = '<span class="badge badge-danger">'.__('No').'</span>';
                    }else{
                        $featured = '<span class="badge badge-success">'.__('Yes').'</span>';
                    }
                    return $featured;
                })
                
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("sets",$row->id).'" class="btn">Flash card</a> ';
                    $btn .= '<a href="'.route("question",$row->id).'"  class="delete btn btn-sm">Quiz</a>';
                    $btn .= '<a href="'.route("praticequestion",$row->id).'"  class="delete btn btn-sm">Practice</a>';
                    $btn .= '<a href="'.route("matchmaking",$row->id).'"  class="delete btn btn-sm">MatchMaking</a>';
                    $btn .= '<a href="'.route("editstudyset",$row->id).'" class="btn"><img src="'.url("assets/imgs/edit.png").'"/></a> ';
                    $btn .= '<a href="'.route("deletestudyset",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->rawColumns(['action', 'name','status','is_featured'])
                ->make(true);
            } else{     
                return view('admin.sets.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try{
            $category = StudySet::where('id',$id)->first();
            $studyset = Sets::where('studyset_id', $id)->get();
            $quiz = Question::where('studyset_id', $id)->get();
            $practice = Pratice_Question::where('studyset_id', $id)->get();
            $match = MatchMaking::where('studyset_id', $id)->get();
        
            foreach( $studyset as $set){
                if($set->image){
                @unlink("images/sets/".$set->image);  
                }
                if($set->image1){
                    @unlink("images/sets/".$set->image1);  
                    }
                $set->delete();  
            }
            foreach( $quiz as $set){
                if($set->image){
                @unlink("images/question/".$set->image);  
                }
                $set->delete();  
            }
            foreach( $practice as $set){
                if($set->image){
                @unlink("images/pratice_question/".$set->image);  
                }
                $set->delete();  
            }
            foreach( $match as $set){
                if($set->image){
                @unlink("images/match/".$set->image);  
                }
                $set->delete();  
            }
                if($category->delete()){
                   @unlink("images/studyset/".$category->cover_image);        
                   @unlink("images/studyset/".$category->main_image);  
                   @unlink("images/studyset/".$category->icon_image);  
                   return back()->with('error', __('Studyset Delete Successfully.'));
                }
            // }
        } catch (Exception $e) {
            return redirect('category')->with($e);
        }
    }
    public function edit(Request $request,$id)
    {
        try {
            $category = Category::select('*')->get();
            $user = StudySet::where('id',$id)->first();
            return view('admin.studyset.edit',['result'=>$user, 'category'=>$category]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
        try{        
            if($request->reward_type == 3){
                $validator = Validator::make($request->all(),[
                    'name' => 'required|min:2',
                    'reward_type' => 'required',
                    'category_id'=>'required',
                    'status'=>'required',
                  
                ]);
            } else {
                $validator = Validator::make($request->all(),[
                    'name' => 'required|min:2',
                    'status'=>'required',
                    'reward_type' => 'required',
                    'category_id'=>'required',
                    'reward_points'=>'required',
                    'max_userpoints'=>'required'
                ]);
            }
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
            
                $user = StudySet::where('id',$request->id)->first();
                if (isset($user->id)) {
                   $user->name = $request->name;
                   $user->category_id = $request->category_id;
                   $user->reward_type = $request->reward_type;
                   $user->reward_points = $request->reward_points;
                   $user->featured = $request->featured;
                   
                   $user->max_userpoints = $request->max_userpoints;
                   $user->status = $request->status;
                   $slug = str::slug($request->name, '-');
                   $user->slug = $this->makeUniqueSlug($slug);
                   $org_name = $request->file('cover_image');
                   if ($org_name !=null) {
                    if($user->cover_image!=null){
                        @unlink("images/studyset/".$user->cover_image);   
                       }
                       $user->cover_image = saveImage1($org_name,$this->folder,1);
                     
                   }
                   $org_name = $request->file('main_image');
                   if ($org_name !=null) {
                      if($user->main_image!=null){
                       @unlink("images/studyset/".$user->main_image);   
                      }
                       $user->main_image = saveImage1($org_name,$this->folder,2);
                   }
                   $org_name = $request->file('icon_image');
                   if ($org_name !=null) {
                    if($user->icon_image!=null){
                        @unlink("images/studyset/".$user->icon_image);   
                       }
                       $user->icon_image = saveImage1($org_name,$this->folder,3);
                     
                   }
                    if($user->save()){
                        $exists = DB::table('views_studysets')->where('studyset_id', $user->id)->exists();

                        if (!$exists) {
                            $data = [
                                'studyset_id' =>  $user->id,
                             
                                // Add more columns and values as needed
                            ];
                            
                            // Insert the record
                            DB::table('views_studysets')->insert($data);
                        }                  
                        
                        return response()->json(array('status' => 200, 'success'=>__('Label.success_edit_category')));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=> __('Label.error_edit_category')));
                    }
                } 
            }
        } catch(Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

    private function makeUniqueSlug($slug)
    {
        $originalSlug = $slug;
        $count = 1;

        while (StudySet::where('slug', $slug)->exists()) {
            $slug = $originalSlug . '-' . $count++;
        }

        return $slug;
    }

}

