<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use App\Models\Users;
use DataTables, URL, DB;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\General_Setting;
use App\Models\Subscription_Plan;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class Subscription_Plan_Controller extends Controller
{
    private $folder = "/subscription";

    public function index()
    {
        try{
            return view('admin.package.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    
    public function add()
    {
        try{
            $type = General_Setting::get();
            foreach ($type as $key => $value) {
                if($value->key == "currency"){
                    $CType = $value;
                    break;
                } else {
                    $CType = "";
                }
            }
            if($CType){
                return view('admin.package.add',['type'=> $CType]);
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    
    public function save(Request $request)
    {
        try {
            $validator = Validator::make($request->all(),[
                'name' => 'required|min:2',
                'price' => 'required',
                'coin' => 'required',
                'product_package' => 'required',
                'currency_type' => 'required',
                'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',            
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $package = new Subscription_Plan();
                $package->name = $request->name;
                $package->price = $request->price;
                $package->coin = $request->coin;
                $package->product_package = $request->product_package;
                $package->currency_type = $request->currency_type;

                $org_name = $request->file('image');
                $package->image = saveImage($org_name,$this->folder);
                if($package->save()){
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_package')));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.errror_add_package')));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

    public function data(Request $request)
    {   
        try{
            if ($request==true) {
                $data = Subscription_Plan::select('*');

                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("editSubscription",$row->id).'" class="btn"><img src="'.url("assets/imgs/edit.png").'" /></a> ';
                    $btn .= '<a href="'.route("deleteSubscription",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
            } else{     
                return view('admin.package.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    
    public function delete($id)
    {
        try{
           $package = Subscription_Plan::where('id',$id)->first();
           $transaction = Transaction::where('plan_subscription_id',$id)->first();

           if ($transaction !== null) {
                return back()->with('error', __('Label.This Package is used on some other table so you can not remove it.'));
            } else {
                if($package->delete()){

                    @unlink("images/subscription/".$package->image);        
                    return back()->with('success', __('Label.Package Delete Successfully.'));  
                }
            }
        } catch(Exception $e) {
            return redirect('subscription')->with($e);
        }
    }
    
    public function edit(Request $request,$id)
    {
        try{
            $package = Subscription_Plan::where('id',$id)->first();
            return view('admin.package.edit',['result'=>$package]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    
    public function update(Request $request)
    {
        try {
            $validator = Validator::make($request->all(),[
                'name' => 'required|min:2',
                'price' => 'required',
                'coin' => 'required',
                'product_package' => 'required',
                'currency_type' => 'required',
                'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',            
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $package = Subscription_Plan::where('id',$request->id)->first();
                if (isset($package->id)) {
                    $package->name = $request->name;
                    $package->price = $request->price;
                    $package->coin = $request->coin;
                    $package->product_package = $request->product_package;
                    $package->currency_type = $request->currency_type;

                    $org_name = $request->file('image');
                    if ($org_name !== null) {
                        $package->image = saveImage($org_name,$this->folder);
                        unlink("images/subscription/".$request->old_image);         
                    } else {
                        $package->image = $request->old_image;                    
                    }

                    if($package->save()) {
                        return response()->json(array('status' => 200, 'success'=>__('Label.success_edit_package')));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=> __('Label.error_edit_package')));
                    }
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

}
