

<?php $__env->startSection('title',  __('Faq')); ?>
<?php $__env->startSection('content'); ?>
 
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">Faq</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"> <?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              <?php echo e(__('FAQ')); ?>

            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center" style="margin-top:-14px">
          <a href="<?php echo e(route('faqAdd')); ?>" class="btn btn-default mw-120">add FAQ</a>
        </div>
      </div>
      
      <div class="table-responsive">
        <table class="table table-striped category-table text-center table-bordered" id="your-datatable">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> <?php echo e(__('Label.Id')); ?> </th>              
              <th> Question </th>
              <th> Answer </th>
              <th> <?php echo e(__('Label.Action')); ?> </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.category-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' >",
              next: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' style='transform: rotate(180deg)'>"
            }
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [ [0, 'asc'] ],
          ajax: "<?php echo e(route('faqData')); ?>",
          columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
         
            {data: 'question', name:'question'},
            {data: 'answer', name:'answer'},
          
            {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
        
      });
    });
  </script>
  <script type="text/javascript">
  
    

  </script>

<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/faq/index.blade.php ENDPATH**/ ?>