
<?php $__env->startSection('title', __('Label.Setting')); ?>
<?php $__env->startSection('content'); ?>
  
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-12">
          <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="<?php echo e(route('dashboard')); ?>">
                    <?php echo e(__('Label.Dashboard')); ?>

                </a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
                <a href="<?php echo e(route('setting')); ?>">
                    <?php echo e(__('Label.Setting')); ?>

                </a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
                SMTP Setting
            </li>
          </ol>
        </div>
      </div>
      
        <div class="card custom-border-card mt-3">
        <h5 class="card-header">Email Setting [SMTP]</h5>
        <div class="card-body">
            <form id="smtp_setting">
            <?php echo e(csrf_field()); ?>

            <div class="row col-lg-12">
                <div class="form-group  col-lg-6">
                <label for="status"><?php echo e(__('Label.IS SMTP Active')); ?></label>
                <select name="status" class="form-control" id="status">
                    <option value=""><?php echo e(__('Label.Select Status')); ?></option>
                    <option value="1" <?php echo e($smtp->status == 1  ? 'selected' : ''); ?>>
                    <?php echo e(__('Label.Yes')); ?>

                    </option>
                    <option value="0" <?php echo e($smtp->status == 0  ? 'selected' : ''); ?>>
                    <?php echo e(__('Label.No')); ?>

                    </option>
                </select>
                </div>
                <div class="form-group col-lg-6">
                <input type="hidden" name="smtp_id" value="1">
                <label for="host"><?php echo e(__('Label.Host')); ?></label>
                <input type="text" name="host" class="form-control" id="host" value="<?php echo e($smtp->host); ?>">
                </div>
                <div class="form-group col-lg-6">
                <label for="port"><?php echo e(__('Label.Port')); ?></label>
                <input type="text" name="port" class="form-control" id="port" value="<?php echo e($smtp->port); ?>">
                </div>
                <div class="form-group col-lg-6">
                <label for="protocol"><?php echo e(__('Label.Protocol')); ?></label>
                <input type="text" name="protocol" class="form-control" id="protocol" placeholder="Enter Your protocol" value="<?php echo e($smtp->protocol); ?>">
                </div>
            </div>
            <div class="row col-lg-12">
                <div class="form-group col-lg-6">
                <label for="user"><?php echo e(__('Label.User name')); ?></label>
                <input type="text" name="user" class="form-control" id="user" value="<?php echo e($smtp->user); ?>">
                </div>
                <div class="form-group col-lg-6">
                <label for="pass"><?php echo e(__('Label.Password')); ?></label>
                <input type="password" name="pass" class="form-control" id="pass" value="<?php echo e($smtp->pass); ?>">
                </div>
            </div>
            <div class="row col-lg-12">
                <div class="form-group col-lg-6">
                <label for="from_name"><?php echo e(__('Label.From name')); ?></label>
                <input type="text" name="from_name" class="form-control" id="from_name" value="<?php echo e($smtp->from_name); ?>">
                </div>
                <div class="form-group col-lg-6">
                <label for="from_email"><?php echo e(__('Label.From Email')); ?></label>
                <input type="text" name="from_email" class="form-control" id="from_email" value="<?php echo e($smtp->from_email); ?>">
                </div>
            </div>
            <div class="border-top pt-3 text-right">
                <button type="button" class="btn btn-default mw-120" onclick="smtp_setting()"><?php echo e(__('Label.SAVE')); ?></button>
            </div>
            </form>
        </div>
        </div>

    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">

    function smtp_setting() {
        $("#dvloader").show();
        var formData = new FormData($("#smtp_setting")[0]);

        $.ajax({
            type: 'POST',
            url: '<?php echo e(route("settingsmtp")); ?>',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            success:function(resp){
                $("#dvloader").hide();
                get_responce_message(resp, 'smtp_setting', '<?php echo e(route("setting")); ?>');
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                $("#dvloader").hide();
                toastr.error(errorThrown.msg,'failed');         
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\envato\app\dtquiz_backend\resources\views/admin/setting/smtp.blade.php ENDPATH**/ ?>