
<?php $__env->startSection('title', __('Set')); ?>
<?php $__env->startSection('content'); ?>

<!-- Start: Body-Content -->
<div class="body-content">
    <!-- mobile title -->
    <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>
    <h5>Study Set: <?php echo e($name); ?></h5>
    <div class="border-bottom row mb-3">
        <div class="col-sm-10">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
                </li>
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('sets',['id'=>$id])); ?>"> Flash Card</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                Add   Flash Card 
                </li>
            </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
            <a href="<?php echo e(route('sets', ['id'=>$id])); ?>" class="btn btn-default mw-120"
                style="margin-top:-14px">Sets</a>
        </div>
    </div>

    <div class="card custom-border-card mt-3">
        <form enctype="multipart/form-data" id="save_studyset">
            <?php echo csrf_field(); ?>

            <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Term</label>
                        <input name="question" type="text" class="form-control"
                            placeholder="<?php echo e(__('Label.Please Enter Category')); ?>">
                    </div>
                </div>
            </div>
            <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="description">Definition</label>
                        <textarea id="description"  class="form-control" rows="4" name="description"></textarea>
                    </div>
                </div>
            </div>
            <div class="form-row">
    				<div class="col-md-6"> 
    					<div class="form-group"> 
    						<label for="image"><?php echo e(__('Label.IMAGE')); ?></label> 
    						<input type="file" class="form-control" id="image" name="image" > 
    						<label class="mt-1"><?php echo e(__('Label.Note_Image')); ?></label>
    					</div>
    				</div>
    				<div class="col-md-6"> 
    					<div class="form-group">
    						<div class="custom-file ml-5"> 
    							<?php $app = URL::asset('/assets/imgs/1.png') ?>
    							<img  src="<?php echo e($app); ?>" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
    						</div>
    					</div>
    				</div> 
    			</div>
            <div class="border-top pt-3">
                <button type="button" class="btn btn-default mw-120"
                    onclick="save_studyset()"><?php echo e(__('Label.SAVE')); ?></button>
                <a href="<?php echo e(route('studyset')); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('Label.CANCEL')); ?></a>
            </div>
        </form>
    </div>
</div>
<!-- End: Body-Content -->
</div>
<!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
    function save_studyset() {
        $("#dvloader").show();
        var formData = new FormData($("#save_studyset")[0]);
        $.ajax({
            type: 'POST',
            url: '<?php echo e(route("setsSave", ["id"=>$id])); ?>',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            success: function(resp) {
                $("#dvloader").hide();
                get_responce_message(resp, 'save_studyset', '<?php echo e(route("sets",["id"=>$id] )); ?>');
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                $("#dvloader").hide();
                toastr.error(errorThrown.msg, 'failed');
            }
        });
    }
</script>


<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/sets/add.blade.php ENDPATH**/ ?>