<?php

namespace App\Http\Controllers\Admin;

use App;
use Validator;
use App\Models\Users;
use App\Models\Level;
use App\Models\Contest;
use App\Models\Language;
use App\Models\Question;
use App\Models\Category;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\Subscription_Plan;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class AdminController extends Controller
{
    public function dashboard()
    {   
        try {
            $user  = Users::get()->count();
            $category  = Category::get()->count();
            $level  = level::get()->count();
            $question = Question::get()->count();
            
            $subscription = Subscription_Plan::select('id','name','price','image','coin','currency_type')->get();
            $user_table = Users::select('id','fullname','email','mobile_number','profile_img','type','c_date') 
                            ->latest()->take(5)->get();

            $transaction = Transaction::with('users')
                        ->with('plan_subscription')
                        ->orderBy('transaction.id', 'DESC')
                        ->take(5)
                        ->get();

            $latest_contest = Contest::select('*')->latest()->take(4)->get();

            $upcomming_contest = Contest::select('*')
                        ->where('start_date', '>=', date('Y-m-d H:i:s'))
                        ->orderBy('start_date','asc')
                        ->take(5)
                        ->get();

            $pack_data = [];	
            foreach($subscription as $row) {
                $pack_data['label'][] = $row->name;
                $pack_data['price'][] = $row->price;
                $pack_data['type'][] = $row->currency_type;
            }

            $comming_contest = [];
            foreach($upcomming_contest as $row) {
                $comming_contest['start_date'][] = $row->start_date;
            }

            $data['user'] = $user;
            $data['category'] = $category;
            $data['level'] = $level;
            $data['question'] = $question;
            $pack_data = json_encode($pack_data);
            $data['transaction'] = $transaction;
            $data['latest_contest'] = $latest_contest;
            $data['upcomming_contest'] = $upcomming_contest;

            return view('admin.dashboard',['result'=>$data, 'user_data'=>$user_table, 'package'=>$pack_data,'transaction'=>$transaction, 'latest_contest'=>$latest_contest, 'upcomming_contest'=>$upcomming_contest, 'comming_contest'=>$comming_contest]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

    public function language($id)
    {
        try{
            Language::where('status', 1)->update(['status' => 0]);

            $language = Language::where('id',$id)->first();
            if(isset($language->id)){
                $language->status = 1;
                if($language->save()){
                    App::setLocale($language->lang_code);
                    session()->put('locale', $language->lang_code);
                    return back()->with('success', __('Label.Language Change Successfully.'));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

}
