<?php

namespace App\Http\Controllers\Admin;

use DB;
use URL;
use Validator;
use DataTables;
use App\Models\Level;
use App\Models\Winners;
use App\Models\Contest;
use App\Models\Question;
use Illuminate\Http\Request;
use App\Models\Contest_Report;
use App\Models\Wallet_Transaction;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class ContestController extends Controller
{

    private $folder = "/contest";

    public function index()
    {
        try {
            return view('admin.contest_list.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function add()
    {
        try {
            $contest = Level::select('id', 'name')->get();
            return view('admin.contest_list.add', ['result' => $contest]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function save(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'level_id' => 'required',
                'name' => 'required|min:2',
                'start_date' => 'required',
                'end_date' => 'required',
                'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'price' => 'required',
                'no_of_user' => 'required',
                'no_of_user_prize' => 'required',
                'no_of_rank' => 'required|numeric|max:10',
                'total_prize' => 'required'
            ]);
            if ($validator->fails()) {
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors' => $errs));
            } else {
                $contest = new Contest();
                $contest->level_id = $request->level_id;
                $contest->name = $request->name;
                $contest->start_date = $request->start_date;
                $contest->end_date = $request->end_date;
                $contest->price = $request->price;
                $contest->no_of_user = $request->no_of_user;
                $contest->no_of_user_prize = $request->no_of_user_prize;
                $contest->no_of_rank = $request->no_of_rank;
                $contest->total_prize = $request->total_prize;
                $contest->prize_json = $this->get_prize_list($request->no_of_rank, $request->no_of_user_prize, $request->total_prize);
                $contest->status = '1';
                $contest->type = '0';

                $org_name = $request->file('image');
                $contest->image = saveImage($org_name, $this->folder);

                if ($contest->save()) {
                    return response()->json(array('status' => 200, 'success' => __('Label.success_add_contest')));
                } else {
                    return response()->json(array('status' => 400, 'errors' => __('Label.error_add_contest')));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function get_prize_list($no_of_rank = '10', $no_user_user = null, $total_amount = null)
    {
        try {
            if ($no_user_user <= 10 && $no_user_user == $no_of_rank) {
                $new_rank = $no_of_rank;
                $new_user_user = $no_user_user;
                $range_new = round($new_user_user / $new_rank);
            } else if ($no_of_rank > 3) {
                $new_rank = $no_of_rank - 3;
                $new_user_user = $no_user_user - 3;
                $range_new = round($new_user_user / $new_rank);
            }

            $pecent = 100;
            $ranges = [100, 75, 70, 65, 60, 55, 50, 45, 40, 35];
            $range = $ranges[$no_of_rank - 1];
            $sum = 0;

            $row = [];
            $range_new1 = 0;
            $is_stop = 0;
            for ($i = 0; $i < $no_of_rank; $i++) {
                $per = ($pecent * $range) / 100;
                $pecent -= round($per);
                $sum += round($per);
                $data = [];
                $data['percentage'] = number_format($per, 2);
                $data['winning_amount'] = ($total_amount * $per) / 100;
                if ($i > 2) {
                    if ($i == 3) {
                        $range_new1 = $i + 1;
                    }

                    if ($no_user_user == $new_rank) {
                        $data['rank'] = $i + 1;
                    } else if ($no_user_user < ($range_new1 + $range_new)) {
                        $data['rank'] = $range_new1 . ' to ' . $no_user_user;
                        $is_stop = 1;
                    } else {
                        $data['rank'] = $range_new1 . ' to ' . ($range_new1 + $range_new);
                    }
                    $range_new1 += $range_new + 1;
                } else {
                    $range_new1 = $i + 1;
                    $data['rank'] = number_format($i + 1, 0);
                }

                $row[] = $data;
                if ($is_stop == 1) {
                    break;
                }
            }

            $array['win_list'] = $row;
            // p($array);
            return json_encode($array);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function data(Request $request)
    {
        try {
            if ($request == true) {

                $data = Contest::select('*')->get();

                for ($i = 0; $i < count($data); $i++) {
                    $JoinUserCount = Wallet_Transaction::select('*')
                        ->where('contest_id', $data[$i]->id)
                        ->count();
                    $data[$i]->total_participants_user = $JoinUserCount;
                }
                return DataTables()::of($data)
                    ->addIndexColumn()
                    ->addColumn('action', function ($row) {
                        $btn = '<a href="' . route("editContest", $row->id) . '" class="btn mr-2"><img src="' . url("assets/imgs/edit.png") . '" /></a> ';
                        $btn .= '<a href="' . route("deleteContest", $row->id) . '" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="' . url("assets/imgs/trash.png") . '" /></a>';
                        return $btn;
                    })
                    ->addColumn('winner', function ($row) {
                        if ($row->end_date >= date("Y-m-d h:i:s")) {
                            $btn = '<a href="" class="btn text-white p-1" style="background:#ff9700;font-size:14px;font-weight: bold;"> NOT ENDED</a> ';
                            return $btn;
                        } else {
                            $chack = Winners::where('contest_id', $row->id)->get();
                            if (count($chack)) {
                                $btn = '<a href="' . route("contestWinnerList", $row->id) . '" class="btn js-click text-white p-1" style="background:#15ca20; font-size:14px;font-weight: bold;">  WINNER LIST </a> ';
                            } else {
                                $btn = '<a href="' . route("contestMakeWinner", $row->id) . '" class="btn js-click text-white p-1" style="background:#0dceec; font-size:14px;font-weight: bold;">  MAKE WINNER </a> ';
                            }
                            return $btn;
                        }
                    })
                    ->rawColumns(['action', 'winner'])
                    ->make(true);
            } else {
                return view('admin.contest.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function delete($id)
    {
        try {
            $contest = Contest::where('id', $id)->first();
            $question = Question::where('contest_id', $id)->first();

            if ($question !== null) {
                return back()->with('error', __('Label.This Contest is used on some other table so you can not remove it.'));
            } else {
                if ($contest->delete()) {
                    @unlink("images/contest/" . $contest->image);
                    return back()->with('success', "Contest Delete SuccessFully.");
                }
            }
        } catch (Exception $e) {
            return redirect('contest')->with($e);
        }
    }
    public function edit(Request $request, $id)
    {
        try {
            $contest = Contest::where('id', $id)->first();
            $level_id = Level::select('id', 'name')->get();
            return view('admin.contest_list.edit', ['result' => $contest, 'level_id' => $level_id]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function update(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'level_id' => 'required',
                'name' => 'required|min:2',
                'start_date' => 'required',
                'end_date' => 'required',
                'price' => 'required',
                'no_of_user' => 'required',
                'no_of_user_prize' => 'required',
                'no_of_rank' => 'required|numeric|max:10',
                'total_prize' => 'required'
            ]);
            if ($validator->fails()) {
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors' => $errs));
            } else {

                $contest = Contest::where('id', $request->id)->first();
                if (isset($contest->id)) {
                    $contest->level_id = $request->level_id;
                    $contest->name = $request->name;
                    $contest->start_date = $request->start_date;
                    $contest->end_date = $request->end_date;
                    $contest->price = $request->price;
                    $contest->no_of_user = $request->no_of_user;
                    $contest->no_of_user_prize = $request->no_of_user_prize;
                    $contest->no_of_rank = $request->no_of_rank;
                    $contest->total_prize = $request->total_prize;
                    $contest->prize_json = $this->get_prize_list($request->no_of_rank, $request->no_of_user_prize, $request->total_prize);
                    $contest->status = '1';
                    $contest->type = '0';

                    $org_name = $request->file('image');

                    if ($org_name !== null) {
                        $contest->image = saveImage($org_name, $this->folder);
                        @unlink("images/contest/" . $request->old_image);
                    } else {
                        $contest->image = $request->old_image;
                    }
                    if ($contest->save()) {
                        return response()->json(array('status' => 200, 'success' => __('Label.success_edit_contest')));
                    } else {
                        return response()->json(array('status' => 400, 'errors' => __('Label.error_edit_contest')));
                    }
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function make_winner($contestId)
    {
        try {

            $where = 'id=' . $contestId;

            // $contestData = $this->getByID($where, 'contest_master');
            $contestData = Contest::where('id', $contestId)->first();

            if (isset($contestData['id']) && $contestData['id'] != '') {
                $no_of_user_prize = $contestData['no_of_user_prize'];
                $whereGet = 'contest_id=' . $contestId;

                //$rank = $this->getRankByContestId($whereGet, $no_of_user_prize);
                $rank = Contest_Report::select(DB::raw(' RANK() OVER (ORDER BY score DESC) as `rank`'), 'id', 'score', 'contest_id', 'user_id')
                    ->groupBy('user_id')
                    ->where('contest_id', $contestId)
                    ->orderBy('rank', 'ASC')
                    ->get();

                $winJson = json_decode($contestData['prize_json']);
                $data = [];
                foreach ($winJson->win_list as $row) {
                    $between = explode(' to ', $row->rank);
                    if (count($between) > 1) {
                        $rowData = $row;
                        for ($i = $between[0]; $i <= $between[1]; $i++) {
                            $rowData = [];
                            $rowData['rank'] = $i;
                            $rowData['winning_amount'] = $row->winning_amount;
                            $rowData['percentage'] = $row->percentage;
                            $data[] = $rowData;
                        }
                    } else {
                        $rowData = [];
                        $rowData['rank'] = $between[0];
                        $rowData['winning_amount'] = $row->winning_amount;
                        $rowData['percentage'] = $row->percentage;
                        $data[] = $rowData;
                    }
                }
                $winnList = array();
                foreach ($rank as $key => $usersData) {
                    $data[$key]['score'] = $usersData['score'];
                    $data[$key]['user_id'] = $usersData['user_id'];
                    $data[$key]['contest_id'] = $usersData['contest_id'];
                    $winnList[] = $data[$key];
                }
                $whereDelete = 'contest_id=' . $contestId;

                // $this->Common_model->delete($whereDelete, 'winners');
                $Cdelete = Winners::where('contest_id', $contestId)->delete();

                foreach ($winnList as $win) {
                    $winInsert['price'] = $win['winning_amount'];
                    $winInsert['percentage'] = $win['percentage'];
                    $winInsert['rank'] = $win['rank'];
                    $winInsert['score'] = $win['score'];
                    $winInsert['user_id'] = $win['user_id'];
                    $winInsert['contest_id'] = $win['contest_id'];

                    // $contestId = $this->Common_model->insert($winInsert, 'winners');
                    Winners::insert($winInsert);
                }
                return redirect(URL::to('/') . '/admin/contest');
            }
        } catch (Exception $e) {
            $res = array('status' => 400, 'message' => $this->lang->line('error'));
            echo json_encode($res);
            exit;
        }
    }
    public function winner_list($id, Request $request)
    {
        try {
            return view('admin.contest_list.contest_leaderboard', ['id' => $id]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function leaderboard($id)
    {
        try {
            $data = Winners::where('contest_id', $id)
                ->limit(10)
                ->with('users')
                ->get();

            return DataTables()::of($data)
                ->addIndexColumn()
                ->make(true);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}
