<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use App\Models\Level;
use App\Models\Contest;
use DataTables, URL, DB;
use App\Models\Question;
use Illuminate\Http\Request;
use App\Models\Pratice_Question;
use App\Models\Pratice_Leaderborad;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class LevelController extends Controller
{

    public function index()
    {
        try{
            return view('admin.level.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add()
    {
        try{
            return view('admin.level.add');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request)
    {
        try{
            $validator = Validator::make($request->all(),[
                'name' => 'required|min:2',
                'level_order' => 'required',
                'score' => 'required',
                'total_question' => 'required',
                'win_question_count' => 'required',            
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $user = new Level();
                $user->name = $request->name;
                $user->level_order = $request->level_order;
                $user->score = $request->score;
                $user->total_question = $request->total_question;
                $user->win_question_count = $request->win_question_count;

                if($user->save()){
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_level')));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_level') ));
                }
            }
        } catch(Exception $e){
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        } 
    }
    public function data(Request $request)
    {   
        try{
            if ($request==true) {
                $data = Level::select('*');

                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("editLevel",$row->id).'" class="btn"><img src="'.url("assets/imgs/edit.png").'" /></a> ';
                    $btn .= '<a href="'.route("deleteLevel",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
            } else{     
                return view('admin.level.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try{
            $level = Level::where('id',$id)->first();
            $contest = Contest::where('level_id',$id)->first();
            $pratice_leaderborad = Pratice_Leaderborad::where('level_id',$id)->first();
            $pratice_question = Pratice_Question::where('level_id',$id)->first();
            $question = Question::where('level_id',$id)->first();

            if ($contest !== null) {
                return back()->with('error', __('Label.This Level is used on some other table so you can not remove it.'));
            } elseif ($question) {
                return back()->with('error', __('Label.This Level is used on some other table so you can not remove it.'));      
            } elseif ($pratice_leaderborad) {
                return back()->with('error', __('Label.This Level is used on some other table so you can not remove it.'));      
            } elseif ($pratice_question) {
                return back()->with('error', __('Label.This Level is used on some other table so you can not remove it.'));      
            } else {
                if($level->delete()){
                    return back()->with('error', __('Level Delete Successfully.'));
                }
            }
        } catch(Exception $e) {
            return redirect('level')->with($e);
        }
    }
    public function edit(Request $request,$id)
    {   
        try{
            $user = Level::where('id',$id)->first();
            return view('admin.level.edit',['result'=>$user]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
        try{
            $validator = Validator::make($request->all(),[
                'name' => 'required|min:2',
                'level_order' => 'required',
                'score' => 'required',
                'total_question' => 'required',
                'win_question_count' => 'required',            
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else{
                $user = Level::where('id',$request->id)->first();
                if (isset($user->id)) {
                    $user->name = $request->name;
                    $user->level_order = $request->level_order;
                    $user->score = $request->score;
                    $user->total_question = $request->total_question;
                    $user->win_question_count = $request->win_question_count;

                    if($user->save()){
                        return response()->json(array('status' => 200, 'success'=> __('Label.success_edit_level') ));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=> __('Label.error_edit_level') ));
                    }
                }
            }
        } catch(Exception $e){
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

}
