<?php

namespace App\Http\Controllers\Api;

use URL;
use Validator;
use App\Models\Level;
use App\Models\Users;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\General_Setting;
use App\Models\Earnpoint_Setting;
use App\Models\QuestioLeaderboard;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use App\Models\Refer_Earn_Transaction;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class AuthController extends Controller
{
    use AuthenticatesUsers;

    private $folder = "/user";
    protected $redirectTo = 'admin/login';

    public function __construct()
    {
        $this->middleware('guest', ['except' => 'logout']);
    }

    // -------------- Login/Register -----------------
    public function registration(Request $request)
    {
        try {
            $validator = Validator::make(
                $request->all(),
                [
                    'username' => 'required',
                    'mobile_number' => 'required',
                    'email' => 'required|unique:users|email',
                    'password' => 'required',
                ],
                [
                    'email.required' => __('api_msg.please_enter_required_fields'),
                    'email.unique' => __('api_msg.email_address_already_exists')
                ]
            );
            if ($validator->fails()) {
                $errors = $validator->errors()->first('email');
                $data['status'] = 400;
                if ($errors) {
                    $data['message'] = $errors;
                } else {
                    $data['message'] = __('api_msg.please_enter_required_fields');
                }
                $data['result'] = [];
                return $data;
            } else {
                $user = new Users();
                if ($request->fullname) {
                    $user->fullname = $request->fullname;
                } else {
                    $user->fullname = $request->username;
                }
                $user->username = $request->username;
                $user->mobile_number = $request->mobile_number;
                $user->email = $request->email;
                $user->password = Hash::make($request->password);
                $user->instagram_url = "";
                $user->facebook_url = "";
                $user->twitter_url = "";
                $user->biodata = "";
                $user->profile_img = "";
                $user->address = "";
                $user->reference_code = Str::random(14);
                $user->pratice_quiz_score = 0;
                $user->total_score = 0;
                $user->total_points = 0;
                if ($request->device_token) {
                    $user->device_token = $request->device_token;
                } else {
                    $user->device_token = "";
                }
                $user->type = 1;

                $parent_reference_code = $request->parent_reference_code;
                if ($request->parent_reference_code) {
                    $user->parent_reference_code = $parent_reference_code;
                } else {
                    $user->parent_reference_code = "";
                }
                if ($user->save()) {

                    if ($parent_reference_code) {
                        $user_list = Users::where('reference_code', $parent_reference_code)->first();

                        $referUserPoint = Earnpoint_Setting::where('type', 3)->first();

                        if ($user_list && $referUserPoint) {

                            $chack_daily_limit = Refer_Earn_Transaction::where('refered_date', date('Y-m-d'))->where('reference_code', $parent_reference_code)->get();
                            $type = General_Setting::get();
                            foreach ($type as $key => $value) {
                                if ($value->key == "daily_refer_limit") {
                                    $limit = $value;
                                    break;
                                } else {
                                    $limit = 0;
                                }
                            }
                            $num = (int)$limit->value;
                            if (count($chack_daily_limit) < $num) {

                                $refer = new Refer_Earn_Transaction();
                                $refer->parent_user_id = $user_list->id;
                                $refer->child_user_id = $user->id;
                                $refer->reference_code = $user_list->reference_code;
                                $refer->parent_user_referred_point = $referUserPoint->value;
                                $refer->child_user_earned_point = $referUserPoint->value;
                                $refer->earn_point_type = $referUserPoint->type;
                                $refer->refered_date = date("Y-m-d");
                                $refer->save();

                                $chiled_user = Users::where('id', $user->id)->first();
                                $chiled_user->total_points = $referUserPoint->value;
                                $chiled_user->save();

                                $parent_user = Users::where('id', $user_list->id)->first();
                                $sum = $parent_user->total_points + $referUserPoint->value;
                                $parent_user->total_points = $sum;
                                $parent_user->save();
                            }
                        } else {
                            $user->parent_reference_code = "";
                        }
                    }

                    $data['status'] = 200;
                    $data['message'] = __('api_msg.user_registration_sucessfuly');

                    $userdata = Users::where('id', $user->id)->first();
                    $data['result'] = array($userdata);

                    return $data;
                } else {
                    $data['status'] = 400;
                    $data['message'] = __('api_msg.data_not_save');
                    return $data;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function login(Request $request)
    {
        try {
            if ($request->type == 1) {

                $validation = Validator::make(
                    $request->all(),
                    [
                        'email' => 'required|email',
                        'type' => 'required',
                        'password' => 'required',
                    ],
                    [
                        'email.required' => __('api_msg.please_enter_required_fields'),
                    ]
                );
                if ($validation->fails()) {

                    $errors = $validation->errors()->first('email');
                    $data['status'] = 400;
                    if ($errors) {
                        $data['message'] = $errors;
                    } else {
                        $data['message'] = __('api_msg.please_enter_required_fields');
                    }
                    $data['result'] = [];
                    return $data;
                }
            } else {
                $validation = Validator::make(
                    $request->all(),
                    [
                        'email' => 'required|email',
                        'type' => 'required',
                    ],
                    [
                        'email.required' => __('api_msg.please_enter_required_fields'),
                    ]
                );
                if ($validation->fails()) {
                    $errors = $validation->errors()->first('email');
                    $data['status'] = 4000;
                    if ($errors) {
                        $data['message'] = $errors;
                    } else {
                        $data['message'] = __('api_msg.please_enter_required_fields');
                    }
                    $data['result'] = [];
                    return $data;
                }
            }

            $email = $request->email;


            if ($request->file('profile_img')) {
                $org_name = $request->file('profile_img');
            } else {
                $profile_img = "";
            }
            if ($request->username) {
                $username = $request->username;
            } else {
                $username = "";
            }
            if ($request->device_token) {
                $device_token = $request->device_token;
            } else {
                $device_token = "";
            }

            $userData = Users::where('type', $request->type)->first();
            if ($request->type == '1') {
                $userEmail = Users::where('email', $request->email)->first();
                if ($userEmail && $userEmail->email) {
                    if (Hash::check($request->password, $userEmail->password) == true) {
                        $userEmail->total_score = round($userEmail->total_score);
                        $result['status'] = 200;
                        $result['message'] = "Login Successfully.";
                        $result['result'] = array($userEmail);
                        return $result;
                    } else {
                        $data["status"] = 400;
                        $data["message"] = __('api_msg.username_and_pasword_is_wrong');
                        $data['result'] = [];
                        return $data;
                    }
                } else {
                    $data["status"] = 400;
                    $data["message"] = __('api_msg.username_and_pasword_is_wrong');
                    $data['result'] = [];
                    return $data;
                }
            }

            if ($request->type == '2') {

                $userData = Users::where('email', $request->email)->where('type', $request->type)->first();
                if ($userData) {

                    $userData->total_score = round($userData->total_score);
                    $path = url('images/user/' . $userData->profile_img);
                    $userData['profile_img'] = $path;

                    $result['status'] = 200;
                    $result['message'] = __('api_msg.login_successfully');

                    $userData['user_type'] = "Login";
                    $result['result'] = array($userData);
                    return $result;
                } else {

                    if (empty($username)) {
                        $user_name = rand(0, 1000);
                        $email_array = explode('@', $email);
                        $username = $email_array[0] . $user_name;
                    }

                    $user = new Users();
                    $user->fullname = $username;
                    $user->username = $username;
                    $user->email = $email;
                    $user->reference_code = Str::random(14);
                    $user->pratice_quiz_score = 0;
                    $user->total_score = 0;
                    $user->total_points = 0;
                    $user->device_token = $device_token;
                    $user->type = 2;

                    if ($request->file('profile_img')) {
                        $user->profile_img = saveImage($org_name, $this->folder);
                    } else {
                        $user->profile_img = $profile_img;
                    }

                    if ($user->save()) {
                        $data['status'] = 200;
                        $data['message'] = __('api_msg.registration_sucessfully');

                        $userdata = Users::where('id', $user->id)->first();
                        $path = url('images/user/' . $userdata->profile_img);
                        $userdata['profile_img'] = $path;

                        $userdata['user_type'] = "Register";
                        $data['result'] = array($userdata);
                        return $data;
                    } else {
                        $data['status'] = 400;
                        $data['message'] = __('api_msg.data_not_save');
                        return $data;
                    }
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function loginwithotp(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'mobile_number' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $chackNumber = Users::where('mobile_number', $request->mobile_number)->first();
                if ($chackNumber) {
                    $data['status'] = 200;
                    $data['message'] = __('api_msg.login_successfully');
                    $data['result'] = array($chackNumber);
                    return $data;
                } else {

                    $user_name = uniqid();
                    $user = new Users();
                    $user->fullname = $user_name;
                    $user->username = $user_name;
                    $user->email = '';
                    $user->password = '';
                    $user->mobile_number = $request->mobile_number;
                    $user->profile_img = '';
                    $user->type = 3;
                    $user->instagram_url = "";
                    $user->facebook_url = "";
                    $user->twitter_url = "";
                    $user->biodata = "";
                    $user->address = "";
                    $user->reference_code = Str::random(14);
                    $user->parent_reference_code = "";
                    $user->pratice_quiz_score = 0;
                    $user->total_score = 0;
                    $user->total_points = 0;
                    $user->device_token = "";
                    $user->c_date = date('Y-m-d');

                    if ($user->save()) {
                        $data['status'] = 200;
                        $data['message'] =  __('api_msg.login_successfully');
                        $userdata = Users::where('id', $user->id)->first();
                        $data['result'] = array($userdata);
                        return $data;
                    } else {
                        $data['status'] = 400;
                        $data['message'] = __('api_msg.not_register');
                        return $data;
                    }
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    //  ------------- Profile -------------------
    public function profile(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $data = Users::where('id', $request->user_id)->first();
                $data->total_score = round($data->total_score);
                if ($data != null) {
                    if ($data->profile_img) {
                        $path = url('images/user/' . $data->profile_img);
                        $data->profile_img = $path;
                    } else {
                        $data->profile_img = "";
                    }

                    $question['status'] = 200;
                    $question['message'] = __('api_msg.get_record_successfully');
                    $question['result'] = array($data);
                    return $question;
                } else {
                    $msg['status'] = 400;
                    $msg['message'] = __('api_msg.record_not_found');
                    $msg['result'] = [];
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function update_profile(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                $data['result'] = [];
                return $data;
            }

            $data = Users::where('id', $request->user_id)->first();
            if ($data) {
                if ($request->fullname) {
                    $data->fullname = $request->fullname;
                }
                if ($request->username) {
                    $data->username = $request->username;
                }
                if ($request->instagram_url) {
                    $data->instagram_url = $request->instagram_url;
                }
                if ($request->facebook_url) {
                    $data->facebook_url = $request->facebook_url;
                }
                if ($request->twitter_url) {
                    $data->twitter_url = $request->twitter_url;
                }
                if ($request->biodata) {
                    $data->biodata = $request->biodata;
                }
                if ($request->file('profile_img')) {

                    $delete_img = $data->profile_img;
                    if ($delete_img) {
                        @unlink("images/user/" . $delete_img);
                    }

                    $org_name = $request->file('profile_img');
                    $fin_img = saveImage($org_name, $this->folder);
                    $data->profile_img = $fin_img;
                }
                if ($request->email) {
                    if ($data->type != 1 && $data->type != 2) {
                        $data->email = $request->email;
                    }
                }
                if ($request->mobile_number) {
                    if ($data->type != 3) {
                        $data->mobile_number = $request->mobile_number;
                    }
                }

                $data->save();
                if ($data->profile_img) {
                    $path = url('images/user/' . $data->profile_img);
                    $data->profile_img = $path;
                }
                $result['status'] = 200;
                $result['message'] = __('api_msg.update_sucessfuly');
                $result['result'] = array($data);
                return $result;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.no_record');
                $msg['result'] = [];
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    // -------------- Password --------------------------
    public function forgot_password(Request $request)
    {
        try {
            $validator = Validator::make(
                $request->all(),
                [
                    'email' => 'required|email',
                ],
                [
                    'email.required' => __('api_msg.please_enter_required_fields'),
                ]
            );
            if ($validator->fails()) {
                $errors = $validator->errors()->first('email');
                $data['status'] = 400;
                if ($errors) {
                    $data['message'] = $errors;
                } else {
                    $data['message'] = __('api_msg.please_enter_required_fields');
                }
                $data['result'] = [];
                return $data;
            } else {
                $msg['status'] = 200;
                $msg['message'] = __('api_msg.new_password_has_been_send_to_your_register_email_address');
                return $msg;

                // $data = Users::where('email', $request->email)->get();
                // if (!$data->isEmpty()) {
                // } else {
                //     $msg['status'] = 400;
                //     $msg['message'] = "Email address is not registered.";
                //     return $msg;
                // }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function password_change(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'password' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {

                $data = Users::where('id', $request->user_id)->first();
                if ($data) {
                    $change_password = Hash::make($request->password);
                    $data->password = $change_password;
                    $data->save();

                    $change_Password['status'] = 200;
                    $change_Password['message'] = __('api_msg.password_change_successfully');
                    return $change_Password;
                } else {
                    $msg['status'] = 400;
                    $msg['message'] = __('api_msg.password_not_changed');
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    // -------------- Recent Quiz By User ----------------
    public function RecentQuizByUser(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $user_id = $request->user_id;

                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');

                $data = QuestioLeaderboard::where('user_id', $user_id)->get();
                if (Count($data)) {

                    for ($i = 0; $i < count($data); $i++) {

                        $level = Level::where('id', $data[$i]->level_id)->first();
                        if ($level) {
                            $data[$i]->level_name = $level->name;
                            $data[$i]->win_question_count = $level->win_question_count;
                        }
                        $user = Users::where('id', $user_id)->first();
                        if ($user) {
                            if ($user->profile_img) {
                                $path = url('images/user/' . $user->profile_img);
                                $data[$i]->profile_img = $path;
                            } else {
                                $data[$i]->profile_img = "";
                            }
                        }
                        if ($data[$i]->is_unlock == 1) {
                            $data[$i]->win_status = "Win";
                        } else {
                            $data[$i]->win_status = "Loss";
                        }
                    }

                    $result['result'] = $data;
                } else {
                    $result['result'] = [];
                }
                return $result;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}