<?php

namespace App\Http\Controllers\Api;

use Validator;
use App\Models\Earn_point;
use Illuminate\Http\Request;
use App\Models\General_Setting;
use App\Http\Controllers\Controller;

class Genaral_Setting_Controller extends Controller
{
    public function genaral_setting()
    {
        try {
            $g_setting = General_Setting::select('id', 'key', 'value')->get();
            if ($g_setting) {

                $path = url('images/app/' . $g_setting[9]->value);
                $g_setting[9]->value = $path;

                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = $g_setting;
                return $result;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.record_not_found');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function earn_point()
    {
        try {
            $spin_wheel = Earn_point::select('id', 'key', 'value', 'type', 'point_type', 'created_at')->where('point_type', '1')->get();
            $daily_login = Earn_point::select('id', 'key', 'value', 'type', 'point_type', 'created_at')->where('point_type', '2')->get();
            $free_coin = Earn_point::select('id', 'key', 'value', 'type', 'point_type', 'created_at')->where('point_type', '3')->get();

            if ($spin_wheel && $daily_login && $free_coin) {
                $subarray['status'] = 200;
                $subarray['message'] = __('api_msg.get_record_successfully');

                $subarray['spin_wheel'] = $spin_wheel;
                $subarray['daily_login'] = $daily_login;
                $subarray['free_coin'] = $free_coin;

                return $subarray;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.record_not_found');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function checkStatus(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'purchase_code' => 'required',
                'package_name' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                if ($request->purchase_code && $request->package_name) {
                    $purchase_code = $request->purchase_code;
                    $package_name = $request->package_name;
                } else {
                    $purchase_code = "";
                    $package_name = "";
                }
                $g_setting = General_Setting::select('id', 'key', 'value')->get();
                foreach ($g_setting as $key => $value) {
                    if ($value->key == "purchase_code") {
                        $PurchaseCode = $value;
                    }
                    if ($value->key == "package_name") {
                        $PackageName = $value;
                    }
                }
                if ($PurchaseCode->value == $purchase_code && $PackageName->value == $package_name) {
                    $data['status'] = 200;
                    $data['message'] = __('api_msg.success');
                    return $data;
                } else {
                    $data['status'] = 400;
                    $data['message'] =  __('api_msg.error');
                    return $data;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}