<?php

namespace App\Http\Controllers\Api;

use DB;
use Validator;
use App\Models\Users;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Contest_Report;
use App\Models\QuestioLeaderboard;
use App\Http\Controllers\Controller;

class Leaderboard_Controller extends Controller
{
    public function getPractiseLeaderBoard(Request $request)
    {
        try {
            $msg['status'] = 200;
            $msg['message'] = __('api_msg.get_record_successfully');

            if ($request->user_id) {
                $user_id = $request->user_id;
            } else {
                $user_id = "";
            }
            // Top 10 User
            $result = Users::select(DB::raw(' RANK() OVER (ORDER BY pratice_quiz_score DESC) as `rank`'), 'id', 'total_score', 'fullname', 'profile_img', 'pratice_quiz_score', 'pratice_quiz_score as score', 'username as name', 'pratice_quiz_score as user_total_score')
                ->where('pratice_quiz_score', '!=', '0')
                ->orderBy('rank', 'ASC')
                ->limit('10')
                ->get();
            if ($result) {
                for ($i = 0; $i < count($result); $i++) {
                    if ($result[$i]->profile_img) {
                        $path = url('images/user/' . $result[$i]->profile_img);
                        $result[$i]->profile_img = $path;
                    } else {
                        $result[$i]->profile_img = "";
                    }
                }
                $msg['result'] = $result;
            } else {
                $msg['result'] = [];
            }

            // Single User
            $user = Users::select(DB::raw(' RANK() OVER (ORDER BY pratice_quiz_score DESC) as `rank`'), 'id', 'total_score', 'fullname', 'profile_img', 'pratice_quiz_score', 'pratice_quiz_score as score', 'username as name', 'pratice_quiz_score as user_total_score')
                ->orderBy('rank', 'ASC')
                ->get();
            if ($user) {
                for ($i = 0; $i < count($user); $i++) {
                    if ($user[$i]->profile_img) {
                        $path = url('images/user/' . $user[$i]->profile_img);
                        $user[$i]->profile_img = $path;
                    } else {
                        $user[$i]->profile_img = "";
                    }
                    if ($user[$i]->id == $user_id) {
                        $msg['user'] = [$user[$i]];
                        break;
                    } else {
                        $msg['user'] = [];
                    }
                }
            } else {
                $msg['user'] = [];
            }
            return $msg;
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    /*public function getLeaderBoardbk(Request $request)
    {
        try {
            if ($request->user_id) {
                $user_id = $request->user_id;
            } else {
                $user_id = "";
            }
            if ($request->type) {
                $type = $request->type;
            } else {
                $type = "";
            }

            $msg['status'] = 200;
            $msg['message'] = __('api_msg.get_record_successfully');

            if (!$user_id && !$type) {

                // Top 10 Users
                $result = Users::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'id', 'total_score', 'fullname', 'profile_img', 'total_score as score', 'username as name', 'total_score as user_total_score')
                    ->where('total_score', '!=', '0')
                    ->orderBy('rank', 'ASC')
                    ->limit('10')
                    ->get();
                if ($result) {
                    for ($i = 0; $i < count($result); $i++) {
                        if ($result[$i]->profile_img) {
                            $path = url('images/user/' . $result[$i]->profile_img);
                            $result[$i]->profile_img = $path;
                        } else {
                            $result[$i]->profile_img = "";
                        }
                    }
                    $msg['result'] = $result;
                } else {
                    $msg['result'] = [];
                }
                $msg['user'] = [];
                return $msg;
            } elseif ($user_id && !$type) {

                // Top 10 Users
                $result = Users::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'id', 'total_score', 'fullname', 'profile_img', 'total_score as score', 'username as name', 'total_score as user_total_score')
                    ->where('total_score', '!=', '0')
                    ->orderBy('rank', 'ASC')
                    ->limit('10')
                    ->get();
                if ($result) {
                    for ($i = 0; $i < count($result); $i++) {
                        if ($result[$i]->profile_img) {
                            $path = url('images/user/' . $result[$i]->profile_img);
                            $result[$i]->profile_img = $path;
                        } else {
                            $result[$i]->profile_img = "";
                        }
                    }
                    $msg['result'] = $result;
                } else {
                    $msg['result'] = [];
                }
                // Single User
                $user = Users::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as rank'), 'id', 'total_score', 'fullname', 'profile_img', 'total_score as score', 'username as name', 'total_score as user_total_score')
                    ->orderBy('rank', 'ASC')
                    ->get();

                if ($user) {
                    for ($i = 0; $i < count($user); $i++) {
                        if ($user[$i]->profile_img) {
                            $path = url('images/user/' . $user[$i]->profile_img);
                            $user[$i]->profile_img = $path;
                        } else {
                            $user[$i]->profile_img = "";
                        }
                        if ($user[$i]->id == $user_id) {
                            $msg['user'] = [$user[$i]];
                            break;
                        } else {
                            $msg['user'] = [];
                        }
                    }
                } else {
                    $msg['user'] = [];
                }
                return $msg;
            } elseif (!$user_id && $type) {

                if ($type == "today") {
                    $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As total_score'), DB::raw('SUM(score) As score'))
                        ->where('date', date("Y-m-d"))
                        ->groupBy('user_id')
                        ->orderBy('rank', 'ASC')
                        ->get();

                    for ($i = 0; $i < count($data); $i++) {
                        $user = Users::select('id', 'fullname', 'username as name', 'profile_img', 'total_score As user_total_score')
                            ->where('id', $data[$i]->user_id)
                            ->first();
                        if ($user && $data[$i]) {
                            if ($user->profile_img) {
                                $path = url('images/user/' . $user->profile_img);
                                $user->profile_img = $path;
                            } else {
                                $user->profile_img = "";
                            }

                            $users['rank'] = $data[$i]->rank;
                            $users['id'] = $data[$i]->user_id;
                            $users['total_score'] = $data[$i]->score;
                            $users['fullname'] = $user->fullname;
                            $users['profile_img'] = $user->profile_img;
                            $users['score'] = $data[$i]->score;
                            $users['name'] = $user->name;
                            $users['user_total_score'] = (int)$user->user_total_score;
                            $final[] = $users;
                        }
                    }
                    $msg['result'] = $final;
                    $msg['user'] = [];
                } elseif ($type == "month") {
                    $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As total_score'), DB::raw('SUM(score) As score'))
                        ->whereMonth('date', date('m'))
                        ->groupBy('user_id')
                        ->orderBy('rank', 'ASC')
                        ->get();
                    for ($i = 0; $i < count($data); $i++) {
                        $user = Users::select('id', 'fullname', 'username as name', 'profile_img', 'total_score As user_total_score')
                            ->where('id', $data[$i]->user_id)
                            ->first();
                        if ($user && $data[$i]) {
                            if ($user->profile_img) {
                                $path = url('images/user/' . $user->profile_img);
                                $user->profile_img = $path;
                            } else {
                                $user->profile_img = "";
                            }

                            $users['rank'] = $data[$i]->rank;
                            $users['id'] = $data[$i]->user_id;
                            $users['total_score'] = $data[$i]->score;
                            $users['fullname'] = $user->fullname;
                            $users['profile_img'] = $user->profile_img;
                            $users['score'] = $data[$i]->score;
                            $users['name'] = $user->name;
                            $users['user_total_score'] = (int)$user->user_total_score;
                            $final[] = $users;
                        }
                    }
                    $msg['result'] = $final;
                    $msg['user'] = [];
                } else {
                    $result = Users::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'id', 'total_score', 'fullname', 'profile_img', 'total_score as score', 'username as name', 'total_score as user_total_score')
                        ->where('total_score', '!=', '0')
                        ->orderBy('rank', 'ASC')
                        ->limit('10')
                        ->get();
                    if ($result) {
                        for ($i = 0; $i < count($result); $i++) {
                            if ($result[$i]->profile_img) {
                                $path = url('images/user/' . $result[$i]->profile_img);
                                $result[$i]->profile_img = $path;
                            } else {
                                $result[$i]->profile_img = "";
                            }
                        }
                        $msg['result'] = $result;
                    } else {
                        $msg['result'] = [];
                    }
                    $msg['user'] = [];
                }
                return $msg;
            } else {

                if ($type == "today") {
                    // --- Top 10 User ---
                    $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As total_score'), DB::raw('SUM(score) As score'))
                        ->where('date', date("Y-m-d"))
                        ->groupBy('user_id')
                        ->orderBy('rank', 'ASC')
                        ->get();

                    for ($i = 0; $i < count($data); $i++) {
                        $user = Users::select('id', 'fullname', 'username as name', 'profile_img', 'total_score As user_total_score')
                            ->where('id', $data[$i]->user_id)
                            ->first();
                        if ($user && $data[$i]) {
                            if ($user->profile_img) {
                                $path = url('images/user/' . $user->profile_img);
                                $user->profile_img = $path;
                            } else {
                                $user->profile_img = "";
                            }

                            $users['rank'] = $data[$i]->rank;
                            $users['id'] = $data[$i]->user_id;
                            $users['total_score'] = $data[$i]->score;
                            $users['fullname'] = $user->fullname;
                            $users['profile_img'] = $user->profile_img;
                            $users['score'] = $data[$i]->score;
                            $users['name'] = $user->name;
                            $users['user_total_score'] = (int)$user->user_total_score;
                            $final[] = $users;
                        }
                    }
                    $msg['result'] = $final;
                    // --- Single User ---
                    $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As total_score'), DB::raw('SUM(score) As score'))
                        ->where('date', date("Y-m-d"))
                        ->where('user_id', $user_id)
                        ->groupBy('user_id')
                        ->orderBy('rank', 'ASC')
                        ->first();
                    if ($data) {
                        $user = Users::select('id', 'fullname', 'username as name', 'profile_img', 'total_score As user_total_score')
                            ->where('id', $data->$user_id)
                            ->first();
                        if ($user && $data) {
                            if ($user->profile_img) {
                                $path = url('images/user/' . $user->profile_img);
                                $user->profile_img = $path;
                            } else {
                                $user->profile_img = "";
                            }

                            $users['rank'] = $data->rank;
                            $users['id'] = $data->user_id;
                            $users['total_score'] = $data->score;
                            $users['fullname'] = $user->fullname;
                            $users['profile_img'] = $user->profile_img;
                            $users['score'] = $data->score;
                            $users['name'] = $user->name;
                            $users['user_total_score'] = (int)$user->user_total_score;
                        }
                        $msg['user'] = $users;
                    } else {
                        $msg['user'] = [];
                    }
                } elseif ($type == "month") {
                    // --- Top 10 User ---
                    $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As total_score'), DB::raw('SUM(score) As score'))
                        ->whereMonth('date', date('m'))
                        ->groupBy('user_id')
                        ->orderBy('rank', 'ASC')
                        ->get();

                    for ($i = 0; $i < count($data); $i++) {
                        $user = Users::select('id', 'fullname', 'username as name', 'profile_img', 'total_score As user_total_score')
                            ->where('id', $data[$i]->user_id)
                            ->first();
                        if ($user && $data[$i]) {
                            if ($user->profile_img) {
                                $path = url('images/user/' . $user->profile_img);
                                $user->profile_img = $path;
                            } else {
                                $user->profile_img = "";
                            }

                            $users['rank'] = $data[$i]->rank;
                            $users['id'] = $data[$i]->user_id;
                            $users['total_score'] = $data[$i]->score;
                            $users['fullname'] = $user->fullname;
                            $users['profile_img'] = $user->profile_img;
                            $users['score'] = $data[$i]->score;
                            $users['name'] = $user->name;
                            $users['user_total_score'] = (int)$user->user_total_score;
                            $final[] = $users;
                        }
                    }
                    $msg['result'] = $final;
                    // --- Single User ---
                    $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As total_score'), DB::raw('SUM(score) As score'))
                        ->whereMonth('date', date('m'))
                        ->where('user_id', $user_id)
                        ->groupBy('user_id')
                        ->orderBy('rank', 'ASC')
                        ->first();
                    if ($data) {
                        $user = Users::select('id', 'fullname', 'username as name', 'profile_img', 'total_score As user_total_score')
                            ->where('id', $data->$user_id)
                            ->first();
                        if ($user && $data) {
                            if ($user->profile_img) {
                                $path = url('images/user/' . $user->profile_img);
                                $user->profile_img = $path;
                            } else {
                                $user->profile_img = "";
                            }

                            $users['rank'] = $data->rank;
                            $users['id'] = $data->user_id;
                            $users['total_score'] = $data->score;
                            $users['fullname'] = $user->fullname;
                            $users['profile_img'] = $user->profile_img;
                            $users['score'] = $data->score;
                            $users['name'] = $user->name;
                            $users['user_total_score'] = (int)$user->user_total_score;
                        }
                        $msg['user'] = $users;
                    } else {
                        $msg['user'] = [];
                    }
                } else {

                    // Top 10 Users
                    $result = Users::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'id', 'total_score', 'fullname', 'profile_img', 'total_score as score', 'username as name', 'total_score as user_total_score')
                        ->where('total_score', '!=', '0')
                        ->orderBy('rank', 'ASC')
                        ->limit('10')
                        ->get();
                    if ($result) {
                        for ($i = 0; $i < count($result); $i++) {
                            if ($result[$i]->profile_img) {
                                $path = url('images/user/' . $result[$i]->profile_img);
                                $result[$i]->profile_img = $path;
                            } else {
                                $result[$i]->profile_img = "";
                            }

                            $result[$i]->user_total_score  = (int)$result[$i]->user_total_score;
                            $result[$i]->total_score  = (int)$result[$i]->total_score;
                        }
                        $msg['result'] = $result;
                    } else {
                        $msg['result'] = [];
                    }
                    // Single User
                    $user = Users::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'id', 'total_score', 'fullname', 'profile_img', 'total_score as score', 'username as name', 'total_score as user_total_score')
                        ->orderBy('rank', 'ASC')
                        ->get();

                    if ($user) {
                        for ($i = 0; $i < count($user); $i++) {
                            if ($user[$i]->profile_img) {
                                $path = url('images/user/' . $user[$i]->profile_img);
                                $user[$i]->profile_img = $path;
                            } else {
                                $user[$i]->profile_img = "";
                            }
                            if ($user[$i]->id == $user_id) {
                                $msg['user'] = array($user[$i]);
                                break;
                            } else {
                                $msg['user'] = [];
                            }
                        }
                    } else {
                        $msg['user'] = [];
                    }
                }
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }*/

    public function getLeaderBoard(Request $request)
    {
        try {
            $user_id = 0;
            if ($request->user_id) {
                $user_id = $request->user_id;
            }

            $type = "";
            if ($request->type) {
                $type = $request->type;
            }

            $msg['status'] = 200;
            $msg['message'] = __('api_msg.get_record_successfully');

            if ($type == "today" || $type == "month") {

                if ($type == "today" || $type == "month") {
                    if ($type == 'today') {

                        $sql = "SELECT * FROM ( SELECT s.*, @rank := @rank + 1 'rank' FROM (SELECT user_id, max(score) as score, max(score) as max_scors, id, is_unlock FROM contest_leaderboard where `date` ='" . date("Y-m-d") . "'  GROUP by user_id ORDER by score DESC) s, (SELECT @rank := 0) init ORDER BY max_scors DESC )r";
                        $data = DB::select($sql);

                        // $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As total_score'), DB::raw('SUM(score) As score'))
                        //     ->where('date', date("Y-m-d"))
                        //     ->groupBy('user_id')
                        //     ->orderBy('rank', 'ASC')
                        //     ->get();
                    } else {

                        $sql = "SELECT * FROM ( SELECT s.*, @rank := @rank + 1 'rank' FROM (SELECT user_id, max(score) as score, max(score) as max_scors, id, is_unlock FROM contest_leaderboard where  month(`date`) ='" . date("m") . "'  GROUP by user_id ORDER by score DESC) s, (SELECT @rank := 0) init ORDER BY max_scors DESC )r";
                        $data = DB::select($sql);

                        // $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As total_score'), DB::raw('SUM(score) As score'))
                        //     ->whereMonth('date', date('m'))
                        //     ->groupBy('user_id')
                        //     ->orderBy('rank', 'ASC')
                        //     ->get();
                    }

                    for ($i = 0; $i < count($data); $i++) {
                        $user = Users::select('id', 'fullname', 'username as name', 'profile_img', 'total_score As user_total_score')
                            ->where('id', $data[$i]->user_id)
                            ->first();
                        if ($user && $data[$i]) {
                            if ($user->profile_img) {
                                $path = url('images/user/' . $user->profile_img);
                                $user->profile_img = $path;
                            } else {
                                $user->profile_img = "";
                            }

                            $users['rank'] = $data[$i]->rank;
                            $users['id'] = $data[$i]->user_id;
                            $users['total_score'] = $data[$i]->score;
                            $users['fullname'] = $user->fullname;
                            $users['profile_img'] = $user->profile_img;
                            $users['score'] = (int)$data[$i]->score;
                            $users['name'] = $user->name;
                            $users['user_total_score'] = (int)$user->user_total_score;
                            $final[] = $users;
                        }
                    }
                    $msg['result'] = $final;
                    $msg['user'] = [];
                    // --- Single User ---
                    if ($type == "today") {

                        $sql = "SELECT * FROM ( SELECT s.*, @rank := @rank + 1 'rank' FROM (SELECT user_id, max(score) as score, max(score) as max_scors, id, is_unlock FROM contest_leaderboard where `date` ='" . date("Y-m-d") . "' AND user_id=" . $user_id . "  GROUP by user_id ORDER by score DESC) s, (SELECT @rank := 0) init ORDER BY max_scors DESC )r";
                        $data = collect(DB::select($sql))->first();


                        // $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As total_score'), DB::raw('SUM(score) As score'))
                        //     ->where('date', date("Y-m-d"))
                        //     ->where('user_id', $user_id)
                        //     ->groupBy('user_id')
                        //     ->orderBy('rank', 'ASC')
                        //     ->first();
                    } else {
                        // $sql = "SELECT * FROM ( SELECT s.*, @rank := @rank + 1 'rank' FROM (SELECT user_id, max(score) as score, max(score) as max_scors, id, is_unlock FROM contest_leaderboard where `date` ='" . date("Y-m-d") . "' AND user_id=" . $user_id . "  GROUP by user_id ORDER by score DESC) s, (SELECT @rank := 0) init ORDER BY max_scors DESC )r";
                        // $data = collect(DB::select($sql))->first();

                        $sql = "SELECT * FROM ( SELECT s.*, @rank := @rank + 1 'rank' FROM (SELECT user_id, max(score) as score, max(score) as max_scors, id, is_unlock FROM contest_leaderboard where month(`date`) ='" . date("m") . "' AND user_id=" . $user_id . "  GROUP by user_id ORDER by score DESC) s, (SELECT @rank := 0) init ORDER BY max_scors DESC )r";
                        $data = collect(DB::select($sql))->first();

                        // $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As total_score'), DB::raw('SUM(score) As score'))
                        //     ->whereMonth('date', date('m'))
                        //     ->where('user_id', $user_id)
                        //     ->groupBy('user_id')
                        //     ->orderBy('rank', 'ASC')
                        //     ->first();
                    }
                    if ($data) {
                        $user = Users::select('id', 'fullname', 'username as name', 'profile_img', 'total_score As user_total_score')
                            ->where('id', $data->user_id)
                            ->first();
                        if ($user && $data) {
                            if ($user->profile_img) {
                                $path = url('images/user/' . $user->profile_img);
                                $user->profile_img = $path;
                            } else {
                                $user->profile_img = "";
                            }

                            $users['rank'] = $data->rank;
                            $users['id'] = $data->user_id;
                            $users['total_score'] = $data->score;
                            $users['fullname'] = $user->fullname;
                            $users['profile_img'] = $user->profile_img;
                            $users['score'] = (int)$data->score;
                            $users['name'] = $user->name;
                            $users['user_total_score'] = (int)$user->user_total_score;
                        }
                        $msg['user'] = $users;
                    }
                }
                return $msg;
            } else {
                // Top 10 Users
                $result = Users::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'id', 'total_score', 'fullname', 'profile_img', 'total_score as score', 'username as name', 'total_score as user_total_score')
                    ->where('total_score', '!=', '0')
                    ->orderBy('rank', 'ASC')
                    ->limit('10')
                    ->get();
                if ($result) {
                    for ($i = 0; $i < count($result); $i++) {
                        if ($result[$i]->profile_img) {
                            $path = url('images/user/' . $result[$i]->profile_img);
                            $result[$i]->profile_img = $path;
                        } else {
                            $result[$i]->profile_img = "";
                        }

                        $result[$i]->score  = (int)$result[$i]->score;
                        $result[$i]->user_total_score  = (int)$result[$i]->user_total_score;
                        $result[$i]->total_score  = (int)$result[$i]->total_score;
                    }
                    $msg['result'] = $result;
                } else {
                    $msg['result'] = [];
                }
                $msg['user'] = [];
                if ($user_id > 0) {
                    // Single User
                    $user = Users::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as `rank`'), 'id', 'total_score', 'fullname', 'profile_img', 'total_score as score', 'username as name', 'total_score as user_total_score')
                        ->orderBy('rank', 'ASC')
                        ->get();

                    if ($user) {
                        for ($i = 0; $i < count($user); $i++) {
                            if ($user[$i]->profile_img) {
                                $path = url('images/user/' . $user[$i]->profile_img);
                                $user[$i]->profile_img = $path;
                            } else {
                                $user[$i]->profile_img = "";
                            }

                            $user[$i]->total_score = (int)$user[$i]->total_score;
                            $user[$i]->score = (int)$user[$i]->score;
                            $user[$i]->user_total_score = (int)$user[$i]->user_total_score;

                            if ($user[$i]->id == $user_id) {
                                $msg['user'] = array($user[$i]);
                                break;
                            } else {
                                $msg['user'] = [];
                            }
                        }
                    }
                }
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function getTodayLeaderBoard(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'level_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {

                $msg['status'] = 200;
                $msg['message'] = __('api_msg.get_record_successfully');

                // --- Top 10 User ---
                // $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY `total_score` DESC) as `rank`'), 'user_id', DB::raw('SUM(`contest_leaderboard`.`score`) As `total_score`'), DB::raw('SUM(score) As score'), 'is_unlock')
                //     ->where('date', date("Y-m-d"))
                //     ->where('level_id', $request->level_id)
                //     ->groupBy('user_id')
                //     ->orderBy('rank', 'ASC')
                //     ->limit('10')
                //     ->get();

                $sql = "SELECT * FROM ( SELECT s.*, @rank := @rank + 1 'rank' FROM (SELECT user_id, max(score) as score, max(score) as max_scors, id, is_unlock FROM contest_leaderboard where `date` ='" . date("Y-m-d") . "' AND level_id=" . $request->level_id . "  GROUP by user_id ORDER by score DESC) s, (SELECT @rank := 0) init ORDER BY max_scors DESC )r";
                $data = DB::select($sql);

                if (count($data)) {
                    for ($i = 0; $i < count($data); $i++) {
                        $user = Users::select('id', 'fullname', 'username as name', 'profile_img', 'total_score As user_total_score')
                            ->where('id', $data[$i]->user_id)
                            ->first();

                        if ($user && $data[$i]) {
                            if ($user->profile_img) {
                                $path = url('images/user/' . $user->profile_img);
                                $user->profile_img = $path;
                            } else {
                                $user->profile_img = "";
                            }

                            $users['rank'] = $data[$i]->rank;
                            $users['user_id'] = $data[$i]->user_id;
                            $users['score'] = $data[$i]->score;
                            $users['max_score'] = $data[$i]->score;
                            $users['is_unlock'] = $data[$i]->is_unlock;
                            $users['fullname'] = $user->fullname;
                            $users['profile_img'] = $user->profile_img;
                            $users['name'] = $user->name;
                            $users['user_total_score'] = (int)$user->user_total_score;
                            $final[] = $users;
                            $msg['result'] = $final;
                        }
                    }
                } else {
                    $msg['result'] = [];
                }

                // --- Single User ---
                // $data = QuestioLeaderboard::select(DB::raw(' RANK() OVER (ORDER BY `total_score` DESC) as `rank`'), 'user_id', DB::raw('SUM(score) As `total_score`'), DB::raw('SUM(score) As score'), 'is_unlock')
                //     ->where('date', date("Y-m-d"))
                //     ->where('user_id', $request->user_id)
                //     ->where('level_id', $request->level_id)
                //     ->groupBy('user_id')
                //     ->orderBy('rank', 'ASC')
                //     ->first();

                $sql = "SELECT * FROM ( SELECT s.*, @rank := @rank + 1 'rank' FROM (SELECT user_id, max(score) as score, max(score) as max_scors, id, is_unlock FROM contest_leaderboard where `date` ='" . date("Y-m-d") . "' AND user_id=" . $request->user_id . " AND level_id=" . $request->level_id . " GROUP by user_id ORDER by score DESC) s, (SELECT @rank := 0) init ORDER BY max_scors DESC )r";
                $data = collect(DB::select($sql))->first();

                if ($data) {

                    $user = Users::select('id', 'fullname', 'username as name', 'profile_img', 'total_score As user_total_score')
                        ->where('id', $data->user_id)
                        ->first();

                    if ($user && $data) {
                        if ($user->profile_img) {
                            $path = url('images/user/' . $user->profile_img);
                            $user->profile_img = $path;
                        } else {
                            $user->profile_img = "";
                        }

                        $users['rank'] = $data->rank;
                        $users['id'] = $data->user_id;
                        $users['total_score'] = $data->score;
                        $users['fullname'] = $user->fullname;
                        $users['profile_img'] = $user->profile_img;
                        $users['score'] = $data->score;
                        $users['name'] = $user->name;
                        $users['user_total_score'] = (int)$user->user_total_score;
                        $msg['user'] = $users;
                    }
                } else {
                    $msg['user'] = [];
                }
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}