@extends('admin.layouts.master')
@section('title', 'Contest Leaderboard')
@section('content')
  
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a></li>
            <li class="breadcrumb-item active" aria-current="page"><a href="{{ route('contest')}}">{{__('Label.Contest')}}</a></li>
            <li class="breadcrumb-item active" aria-current="page">
              Contest Leaderboard
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('contest') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('Label.Contest')}}</a>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-striped contest-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>
              <th> {{__('Label.Name')}} </th>
              <th> {{__('Label.Rank')}} </th>
              <th> {{__('Label.Score')}} </th>
              <th> {{__('Label.Price')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {

        var url = "{{route('contestWinnerListLeaderboard', '')}}"+"/"+{{$id}};
        // alert(url);
        var table = $('.contest-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            }
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [ [0, 'asc'] ],
          ajax: url,
          columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'users.username', name: 'users.username',
              "render": function (data, type, full, meta) {
                if(data){
                  return data;
                } else {
                  return "-";
                }
              }
            },
            {data: 'rank', name: 'rank'}, 
            {data: 'score', name: 'score'},
            {data: 'price', name: 'price'},
          ],
        });
      });
    });
  </script>
@endpush
