@extends('admin.layouts.master')
@section('title', __('Label.Edit Contest'))
@section('content')
	
		<!-- Start: Body-Content -->
		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm">@yield('title')</h1>

			<div class="border-bottom row mb-3">
				<div class="col-sm-10">
					<ol class="breadcrumb">
						<li class="breadcrumb-item">
							<a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
						</li>
						<li class="breadcrumb-item">
							<a href="{{ route('contest') }}">{{__('Label.Contest')}}</a>
						</li>
						<li class="breadcrumb-item active" aria-current="page">
							{{__('Label.Edit Contest')}}
						</li>
					</ol>
				</div>
				<div class="col-sm-2 d-flex align-items-center">
					<a href="{{ route('contest') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.Contest')}}</a>
				</div>
			</div>

			<div class="card custom-border-card mt-3">
				<form enctype="multipart/form-data" id="save_edit_contest">
					{!! csrf_field() !!}
					<div class="form-row">
						<div class="col-md-6 mb-3">
							<div class="form-group">
								<label for="level_id">{{__('Label.LEVEL')}}</label>
								<select class="form-control" id="level_id" name="level_id">
									<option value="">{{__('Label.Select Level')}}</option>
									@foreach ($level_id as $key => $value)
									<option value="{{ $value->id}}" {{ $result->level_id == $value->id  ? 'selected' : ''}}> 
										{{ $value->name }} 
									</option>
									@endforeach  
								</select>
							</div>
						</div>
						<div class="col-md-6 mb-3">
							<div class="form-group">
								<label for="name">{{__('Label.NAME')}}</label>
								<input name="name" type="text" class="form-control" id="name" value="{{$result->name}}">
							</div>
						</div>
					</div>
					<div class="form-row">
						<div class="col-md-6 mb-3">
							<div class="form-group">
								<label for="start_date">{{__('Label.START DATE')}}</label>
								<input name="start_date" type="datetime-local" class="form-control" id="start_date" value="{{$result->start_date}}">
							</div>
						</div>
						<div class="col-md-6 mb-3">
							<div class="form-group">
								<label for="end_date">{{__('Label.END DATE')}}</label>
								<input name="end_date" type="datetime-local" class="form-control" id="end_date" value="{{$result->end_date}}">
							</div>
						</div>
					</div>
					<div class="form-row">
						<div class="col-md-6 mb-3">
							<div class="form-group">
								<label for="image">{{__('Label.IMAGE')}}</label>
								<input type="file" class="form-control" id="image" name="image" value="{{$result->image}}">
								<label class="mt-1">{{__('Label.Note_Image')}}</label>
							</div>
						</div>
						<div class="col-md-6">
							<div class="custom-file ml-5">
								<?php 
									if ($result->image){
										$app = URL::asset('/images/contest').'/'.$result->image;
									} else{
										$app = asset('assets/imgs/1.png');
									}
                  					?>
								<img  src="{{$app}}" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
								<input type="hidden" name="old_image" value="{{$result->image}}">
							</div>
						</div>
					</div>
					<div class="form-row">
						<div class="col-md-12 mb-3">
							<div class="form-group">
								<label for="price">{{__('Label.ENTRY FEE')}}</label>
								<input name="price" type="number" class="form-control" id="price" value="{{$result->price}}">
							</div>
						</div>
					</div>
					<div class="form-row">
						<div class="col-md-6 mb-3">
							<div class="form-group">
								<label for="no_of_user">{{__('Label.NO OF USER')}}</label>
								<input name="no_of_user" type="number" class="form-control" id="no_of_user" value="{{$result->no_of_user}}">
							</div>
						</div>
						<div class="col-md-6 mb-3">
							<div class="form-group">
								<label for="no_of_user_prize">{{__('Label.NO OF USER PRIZE')}}</label>
								<input name="no_of_user_prize" type="number" class="form-control" id="no_of_user_prize" value="{{$result->no_of_user_prize}}">
							</div>
						</div>
					</div>
					<div class="form-row">
						<div class="col-md-6 mb-3">
							<div class="form-group">
								<label for="no_of_rank">{{__('Label.NO OF RANK')}}</label>
								<input name="no_of_rank" type="number" class="form-control" id="no_of_rank" value="{{$result->no_of_rank}}">
							</div>
						</div>
						<div class="col-md-6 mb-3">
							<div class="form-group">
								<label for="total_prize">{{__('Label.TOTAL PRIZE')}}</label>
								<input name="total_prize" type="number" class="form-control" id="total_prize" value="{{$result->total_prize}}">
							</div>
						</div>
					</div>
					<div class="border-top mt-2 pt-3">
						<input type="hidden" value="{{$result->id}}" name="id">
						<button type="button" class="btn btn-default mw-120" onclick="save_edit_contest()">{{__('Label.UPDATE')}}</button>
						<a href="{{route('contest')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
					</div>
				</form>
			</div>
		</div>
		<!-- End: Body-Content -->
	</div>
	<!-- End: Right Contenct -->
@endsection

@push('scripts')
	<script type="text/javascript">

		function save_edit_contest(){
			$("#dvloader").show();
			var formData = new FormData($("#save_edit_contest")[0]);
			$.ajax({
				type:'POST',
				url:'{{ route("contestUpdate") }}',
				data:formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'save_edit_contest', '{{ route("contest") }}');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					$("#dvloader").hide();
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}
	</script>
@endpush
