@extends('admin.layouts.master')
@section('title', __('Label.Contest'))
@section('content')

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Label.Contest')}}
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('contestAdd') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('Label.Add Contest')}}</a>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-striped contest-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>
              <th> {{__('Label.Name')}} </th>
              <th> {{__('Label.Start Date')}} </th>
              <th> {{__('Label.End Date')}} </th>
              <th> {{__('Label.Price')}} </th>
              <th> {{__('Label.No of User')}} </th>
              <th> {{__('Label.Participants User')}} </th>
              <th> {{__('Label.Total Price')}} </th>
              <th> {{__('Label.Winner')}} </th>
              <th> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script type="text/javascript">
    $(document).ready(function() {
      $(function () {
        var table = $('.contest-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            }
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          ajax: "{{ route('contestData') }}",
          columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name', name:'name'},
            {data: 'start_date', name: 'start_date'},
            {data: 'end_date', name: 'end_date'},
            {data: 'price', name: 'price'}, 
            {data: 'no_of_user', name: 'no_of_user'}, 
            { data: 'total_participants_user', name: 'total_participants_user', 
              "render": function (data, type, full, meta) {
                if(data){
                  return data;
                } else {
                  return 0;
                }
              },
            },      
            {data: 'total_prize', name: 'total_prize'}, 
            {data: 'winner', name: 'winner'}, 
            {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
  
@endpush
