@extends('admin.layouts.master')
@section('title', __('Label.Dashboard'))
@section('content')

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="row counter-row">
        <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
          <div class="db-color-card user-card">
            <img src="{{ asset('assets/imgs/user-brown.png') }}" alt="" class="card-icon" />
            <div class="dropdown dropright">
              <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <img src="{{ asset('assets/imgs/dot.png') }}" class="dot-icon" />
              </a>
              <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                <a class="dropdown-item" href="{{ route('user') }}" style="color: #A98471;">{{__('Label.View All')}}</a>
              </div>
            </div>
            <h2 class="counter">
              {{$result['user']}}
              <span>{{__('Label.Users')}}</span>
            </h2>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
          <div class="db-color-card cate-card">
            <img src="{{ asset('assets/imgs/categories-purple.png') }}" alt="" class="card-icon" />
            <div class="dropdown dropright">
              <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <img src="{{ asset('assets/imgs/dot.png') }}" class="dot-icon" />
              </a>
              <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                <a class="dropdown-item" href="{{ route('category') }}" style="color: #736AA6">{{__('Label.View All')}}</a>
              </div>
            </div>
            <h2 class="counter">
              {{$result['category']}}
              <span>{{__('Label.Category')}}</span>
            </h2>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
          <div class="db-color-card artist-card">
            <img src="{{ asset('assets/imgs/LEVEL.png') }}" alt="" class="card-icon" style="color:#6db3c6;" />
            <div class="dropdown dropright">
              <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <img src="{{ asset('assets/imgs/dot.png') }}" class="dot-icon" />
              </a>
              <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                <a class="dropdown-item" href="{{ route('level') }}" style="color: #6DB3C6">{{__('Label.View All')}}</a>
              </div>
            </div>
            <h2 class="counter">
              {{$result['level']}}
              <span>{{__('Label.Level')}}</span>
            </h2>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
          <div class="db-color-card package-card">
            <img src="{{ asset('assets/imgs/QUESRTION.png') }}" alt="" class="card-icon" />
            <div class="dropdown dropright">
              <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <img src="{{ asset('assets/imgs/dot.png') }}" class="dot-icon" />
              </a>
              <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                <a class="dropdown-item" href="{{ route('question') }}" style="color: #C0698B">{{__('Label.View All')}}</a>
              </div>
            </div>
            <h2 class="counter">
              {{$result['question']}}
              <span>{{__('Label.Question')}}</span>
            </h2>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-12 col-xl-8">
          <div class="box-title">
            <h2 class="title">{{__('Label.Recent Added Users')}}</h2>
            <a href="{{ route('user') }}" class="btn btn-link">{{__('Label.View All')}}</a>
          </div>
          <div class="table-responsive">
            <table class="table table-striped">
              <thead>
                <tr>
                  <th>
                    {{__('Label.Full Name')}}
                  </th>
                  <th>
                    {{__('Label.Email')}}
                  </th>
                  <th>
                    {{__('Label.Number')}}
                  </th>
                  <th>
                    {{__('Label.Type')}}
                  </th>
                  <th>
                    {{__('Label.Created Date')}}
                  </th>
                </tr>
              </thead>
              <tbody>
                @foreach ($user_data as $value)
                <tr>
                  <td>
                    <span class="avatar-control">
                      <?php 
                        if($value->profile_img){
                          $app = URL::asset('/images/user').'/'. $value->profile_img; 
                        } else {
                          $app = URL::asset('/assets/imgs/1.png'); 
                        }
                      ?>
                      <img src="{{ $app }}" class="avatar-img">
                      @if($value->fullname)
                        {{$value->fullname}}
                      @else
                        -
                      @endif
                    </span>
                  </td>
                  <td>
                    @if($value->email)
                      {{$value->email}}
                    @else($value->email == 'null')
                      -
                    @endif
                  </td>
                  <td>
                    @if($value->mobile_number)
                      {{$value->mobile_number}}
                    @else($value->mobile_number == 'null')
                      -
                    @endif
                  </td>
                  <td>
                    @if ($value->type == 1)
                    {{__('Label.Normal')}}
                    @elseif($value->type == 2)
                    {{__('Label.Social')}}
                    @else($value->type == 3)
                    {{__('Label.OTP')}}
                    @endif
                  </td>
                  <td>{{$value->c_date}}</td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
          <div class="box-title">
            <h2 class="title">{{__('Label.Subscriptions')}}</h2>
            <a href="{{ route('subscription') }}" class="btn btn-link">{{__('Label.View All')}}</a>
          </div>
          <div class="row">
            <div class="col-12 col-sm-4 mt-1">
              <canvas id="myChart" width="70%" height="100px"></canvas>
            </div>
            <div class="col-12 col-sm-8 mt-2">
              <h2 class="title mt-1" style="font-size: 18px; font-weight: 600;">{{__('Label.Recent Transaction')}}</h2>
              <div class="summary-table-card">
                @foreach ($transaction as $value)
                <div class="border-card">
                  <div class="row">
                    <div class="col-12 col-md">
                      <span class="avatar-control">
                        <?php 
                          if($value->users->profile_img){
                            $app = URL::asset('/images/user').'/'. $value->users->profile_img; 
                          } else {
                            $app = URL::asset('/assets/imgs/1.png'); 
                          }
                        ?>
                        <img src="{{ $app}}" class="avatar-img">
                        {{ string_cut($value->users->fullname ?? '', 9)}}
                      </span>
                    </div>
                    <div class="col">
                      {{$value->transaction_date ?? ''}}
                    </div>
                    <div class="col">
                      <p class="d-flex m-0 align-items-center">
                        <span class="dot bg-green"></span>
                        {{$value->plan_subscription->name ?? '' }}
                      </p>
                    </div>
                    <div class="col">
                      <span class="price">{{$value->plan_subscription->currency_type ?? ''}}{{$value->plan_subscription->price ?? '' }}</span>
                    </div>
                  </div>
                </div>
                @endforeach
              </div>
            </div>
          </div>
          <div class="box-title">
            <h2 class="title">{{__('Label.Latest Contest')}}</h2>
            <a href="{{ route('contest')}}" class="btn btn-link">{{__('Label.View All')}}</a>
          </div>
          <div class="row artist-row">
            @foreach ($latest_contest as $value)
            <div class="col-6 col-md-3">
              <div class="artist-grid-card">
                <span class="avatar-control">
                  <?php 
                    if($value->image){
                      $app = URL::asset('/images/contest').'/'. $value->image; 
                    } else {
                      $app = URL::asset('/assets/imgs/1.png'); 
                    }
                  ?>       
                 <img src="{{$app}}" class="avatar-img mr-3">
                  {{__('Label.Enrty')}}
                  <button class="btn btn-success btn-sm ml-md-1" >&#8377; {{$value->price}}</button>
                </span>
                
                <h3 class="name" style="display: inline-block; text-overflow:ellipsis; white-space:nowrap; overflow:hidden; width:100%;">{{$value->name}}</h3>
                
                <p style="font-size:18">{{__('Label.Total User')}} : <b>{{$value->no_of_user}}</b><br>{{__('Label.Total Prize')}} : <b>{{$value->total_prize}}</b><br>{{__('Label.Winning Rank')}} : <b>{{$value->no_of_rank}}</b></p>
              </div>
            </div>
            @endforeach
          </div>
        </div>
        <div class="col-12 col-xl-4">
          <div class="video-box">
            <div class="box-title mt-0">
              <h2 class="title">{{__('Label.UpComming Contest')}}</h2>
              <a href="{{ route('contest') }}" class="btn btn-link">{{__('Label.View All')}}</a>
            </div>
            <div class="p-3 bg-white mt-4">
              @foreach ($upcomming_contest as $value)
                <?php 
                  if($value->image){
                    $app = URL::asset('/images/contest').'/'. $value->image; 
                  } else {
                    $app = URL::asset('/assets/imgs/1.png'); 
                  }
                ?>
                <img src="{{$app}}" class="img-fluid mx-auto d-block" width="90%">
                <div class="box-title box-border-0 d-flex">
                  <h5 class="f600" style="display: inline-block; text-overflow:ellipsis; white-space:nowrap; overflow:hidden; width:75%;">{{$value->name}}</h5>
                  <button class="btn btn-success btn-sm ">&#8377; {{$value->price}}</button>
                </div>
                <p id="demo" style="color:#fb424a; font-size:18px" class="font-weight-bold mt-2 mb-0 text-center"></p>
                @break
              @endforeach
            </div>
            <div class="box-title" style="margin-top:5px">
            </div>
            <div class="row">              
              @foreach ($upcomming_contest as $key=> $value)
              @if($key > 0)
              <div class="col-sm-6 col-xl-12">
                <div class="media suggested-video">
                  <?php 
                    if($value->image){
                      $app = URL::asset('/images/contest').'/'. $value->image; 
                    } else {
                      $app = URL::asset('/assets/imgs/1.png'); 
                    }
                  ?>
                  <img src="{{$app}}" class="mr-3 poster-img">
                  <div class="media-body">
                    <h5 class="mt-0 video-title">{{$value->name}}</h5>
                    <div class="details">
                      <p class="font-weight-bold" style="color:#fb424a;">{{$value->start_date}}<br> {{__('Label.To')}} <br> {{$value->end_date}} <br></p>
                    </div>
                  </div>
                  <button class="btn btn-success btn-sm">&#8377; {{$value->price}}</button><br>
                </div>
              </div>
              @endif
              @endforeach
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script>
    $(function(){
      //get the pie chart canvas
      var cData = JSON.parse(`<?php echo $package; ?>`);
      var ctx = $("#myChart");

      //pie chart data
      var data = {
        labels: cData.label,
        datasets: [
        {
          data: cData.price,
          backgroundColor: [
          "#DEB887",
          "#A9A9A9",
          "#1D7A46",
          "#F4A460",
          "#DC143C",
          "#2E8B57",
          "#CDA776",
          "#003F5C",
          "#BC5090",
          "#FF6361",
          "#FFF1C9",
          "#DEB887",
          "#A9A9A9",
          "#1D7A46",
          "#F4A460",
          "#DC143C",
          "#2E8B57",
          "#CDA776",
          "#003F5C",
          "#BC5090",
          "#FF6361",
          "#FFF1C9",
          ],
        }
        ]
      };

      //options
      var options = {
        responsive: true,
        title: {
          display: true,
          position: "top",
          text: "{{__('Label.Package Name and Price (INR)')}}",
          fontSize: 18,
          fontColor: "#000"
        },
        legend: {
          title: "text",
          display: true,
          position: 'bottom',
          labels: {
            fontSize: 14,
            fontColor: "#000",
            fontwight: "600"
          }
        }
      };

      //create Pie Chart class object
      var chart1 = new Chart(ctx, {
        type: "doughnut",
        data: data,
        options: options
      });
    });
  </script>
  <script>

    @foreach ($upcomming_contest as $value)

      var countDownDate = new Date("{{$value->start_date}}").getTime();

      var x = setInterval(function() {

        var now = new Date().getTime();
        var distance = countDownDate - now;

        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

        document.getElementById("demo").innerHTML = days + "d " + hours + "h " + minutes + "m " + seconds + "s ";
        if (distance < 0) {
          clearInterval(x);
          document.getElementById("demo").innerHTML = "LIVE";
        }
      }, 1000);
    @break
    @endforeach
  </script>
@endpush
