@extends('admin.layouts.master')
@section('title',  __('Label.Notification Setting'))
@section('content')
  	
 		<!-- Start: Body-Content -->
 		<div class="body-content">
 			<!-- mobile title -->
 			<h1 class="page-title-sm">@yield('title')</h1>

 			<div class="border-bottom row">
 				<div class="col-sm-12">
 					<ol class="breadcrumb">
 						<li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
 						</li>
 						<li class="breadcrumb-item active" aria-current="page">
 							{{__('Label.Notification Setting')}}
 						</li>
 					</ol>
 				</div>
 			</div>

 			<div class="card custom-border-card mt-3">
 				<form id="save_notificationsetting">
 					{!! csrf_field() !!}
 					<div class="form-row">
 						<div class="col-md-6 mb-3">
 							<div class="form-group">
 								<label for="onesignal_apid">{{__('Label.ONESIGNAL APP ID')}}</label>
 								<input name="onesignal_apid" type="text" class="form-control" id="onesignal_apid" value="{{$result['onesignal_apid']}}" placeholder="Enter Onesignal App ID">
 							</div>
 						</div>
 						<div class="col-md-6 mb-3">
 							<div class="form-group">
 								<label for="onesignal_rest_key">{{__('Label.ONESIGNAL REST KEY')}}</label>
 								<input name="onesignal_rest_key" type="text" class="form-control" id="onesignal_rest_key" value="{{$result['onesignal_rest_key']}}" placeholder="Enter Onesignal Rest Key">
 							</div>
 						</div>
 					</div>
 					<div class="border-top mt-2 pt-3">
 						<button type="button" class="btn btn-default mw-120" onclick="save_notificationsetting()">{{__('Label.SAVE')}}</button>
 						<a href="{{route('notification')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
 					</div>
 				</form>
 			</div>
 		</div>
 		<!-- End: Body-Content -->
 	</div>
 	<!-- End: Right Contenct -->
@endsection

@push('scripts')
	<script type="text/javascript">

		function save_notificationsetting(){
			$("#dvloader").show();
			var formData = new FormData($("#save_notificationsetting")[0]);
			$.ajax({
				type:'POST',
				url:'{{ route("notificationSettingsave") }}',
				data:formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'save_notificationsetting', '{{ route("notification") }}');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}
	</script>
@endpush