<?php

namespace App\Http\Controllers\Admin;
use Illuminate\Support\Str as str;
use Validator;  
use DataTables, URL, DB;
use App\Models\Question;
use App\Models\Category;
use App\Models\Faq;
use Illuminate\Http\Request;
use App\Models\Pratice_Question;
use App\Models\Sets;
use App\Models\Pratice_Leaderborad;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Services\PayUService\Exception;
use App\Models\MatchMaking;


class FaqController extends Controller
{
    private $folder = "/faq";
    
    public function index()
    {
        try {
            return view('admin.faq.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add()
    {
        try {
          
            return view('admin.faq.add');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request)
    {
        try {
           
                $validator = Validator::make($request->all(),[
                    'question' => 'required|min:2',
                    'answer' => 'required',
                  
                ]);
            
         
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else{
                $user = new Faq();
                $user->question = $request->question;
                $user->answer = $request->answer;
              
               
                
                
                if($user->save()){
                 

                
                                 
                    
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_studyset') ));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_studyset')));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {
        try {
            if ($request==true) {
                $data = Faq::select('*');
                return DataTables()::of($data)
                ->addIndexColumn()
               
              
                ->editColumn('answer', function($user) {
                  
                    return str::words($user->answer, 100, '...');
                })
             
              
                
                ->addColumn('action', function($row){
                
                    $btn = '<a href="'.route("editfaq",$row->id).'" class="btn"><img src="'.url("assets/imgs/edit.png").'"/></a> ';
                    $btn .= '<a href="'.route("deletefaq",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->rawColumns(['action',])
                ->make(true);
            } else{     
                return view('admin.faq.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try{
            $category = Faq::where('id',$id)->first();
            
        
         
                if($category->delete()){
                 
                   return back()->with('error', __('Faq Delete Successfully.'));
                }
            // }
        } catch (Exception $e) {
            return redirect('category')->with($e);
        }
    }
    public function edit(Request $request,$id)
    {
        try {
           
            $user = Faq::where('id',$id)->first();
          
            return view('admin.faq.edit',['result'=>$user]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
        try{        
           
                $validator = Validator::make($request->all(),[
                    'question' => 'required|min:2',
                    'answer'=>'required',
                  
                ]);
            
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
            
                $user = Faq::where('id',$request->id)->first();
                if (isset($user->id)) {
                   $user->question = $request->question;
                   $user->answer = $request->answer;
                 
                    if($user->save()){
                                     
                        
                        return response()->json(array('status' => 200, 'success'=>__('Label.success_edit_category')));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=> __('Label.error_edit_category')));
                    }
                } 
            }
        } catch(Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

    private function makeUniqueSlug($slug)
    {
        $originalSlug = $slug;
        $count = 1;

        while (StudySet::where('slug', $slug)->exists()) {
            $slug = $originalSlug . '-' . $count++;
        }

        return $slug;
    }

}

