<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use App\Models\Level;
use DataTables, URL, DB;
use App\Models\StudySet;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Models\Classification;
use App\Models\MatchMaking;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class MatchMakingController extends Controller
{

    private $folder = "/match";

    public function index($id)
    {
        try{
            $set=StudySet::where('id', $id)->first();
          
            return view('admin.matchmaking.index')->with(['id'=>$id,  'name'=>$set->name]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add($id)
    {
        try{
            $set=StudySet::where('id', $id)->first();  
            
            $level = Level::select('*')->get();
      
            $category = Category::select('*')->get();
            $level = Level::select('*')->get();
            $classification = Classification::select('*')->get();

            return view('admin.matchmaking.add',[ 'name'=>$set->name, 'id'=> $id, 'category'=>$category, 'level'=>$level,'classification'=>$classification]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request, $id)
    {
        try{
          
                $validator = Validator::make($request->all(),[
                   
                    'question' => 'required',                 
                 
                    'answer' => 'required',
                    
                ]);
            
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $content = $request->question;
               
                $question = new MatchMaking();              
             
                $question->question = $content;
                $question->answer = $request->answer;
                $question->studyset_id = $id;
           
                $org_name = $request->file('image');
                if($org_name!=null){
                $question->image = saveImage1($org_name,$this->folder,1);
                }
                $org_name = $request->file('image1');
                if($org_name!=null){
                $question->image1 = saveImage1($org_name,$this->folder,2);
                }

                if($question->save()){
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_question') ));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_question') ));
                }
            }
        } catch(Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {
        try{        
            if ($request==true) {
                $data = MatchMaking::with('studyset')->where('studyset_id',$request->id)
                      
                        ->get();
            
                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('question', function($row){
                  
                    return $row->question;
                })
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("editmatchmaking",["id"=>$row->id ,"setId"=>$row->studyset_id]).'" class="btn"><img src="'.url("assets/imgs/edit.png").'" /></a> ';
                    $btn .= '<a href="'.route("deletematchmaking",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->rawColumns(['action','question'])
                ->make(true);
            } else{     
                return view('admin.pratice_question.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete(Request $request, $id )
    {
        try{
           
           
            $question = MatchMaking::where('id',$id)->first();
            if ($question->image !=null) {
               if($question->delete()){
                    @unlink("images/match/".$question->image);      
                    @unlink("images/match/".$question->image1);       
                    return back()->with('success', __('Label.Question Delete Successfully.'));   
                }
            } else {
                if($question->delete()){
                    return back()->with('success', __('Label.Question Delete Successfully.'));   
                }
            }
        } catch(Exception $e){
            return redirect('matchmaking')->with($e);
        }
    }
    public function edit(Request $request, $id , $setId)
    {
        try{
            $set=StudySet::where('id', $setId)->first();
            $question = MatchMaking::where('id',$id)->first();
            $category = Category::select('*')->get();
            $level = Level::select('*')->get();
            $classification = Classification::select('*')->get();
            return view('admin.matchmaking.edit',['result'=>$question,
            'category'=>$category,
            'setId'=>$setId,
            'name'=>$set->name,
            'level'=>$level,
            'classification'=>$classification]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
        try {
         
             
                $validator = Validator::make($request->all(),[                   
                    'question' => 'required',                   
                    'answer' => 'required',                   
                ]);
            
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $question = MatchMaking::where('id',$request->id)->first();

                if (isset($question->id)) {
                   
                    $content = $request->question;           
                   
                    $question->question =$content;
                    $question->studyset_id = $question->studyset_id;            
                 
                    $question->answer = $request->answer;
                    $org_name = $request->file('image');
                    if ($org_name !== null) {
                        if($question->image){
                            @unlink("images/match/".$question->image); 
                        }
                        $question->image = saveImage1($org_name,$this->folder,1);
                               
                    } 
                    $org_name = $request->file('image1');
                    if ($org_name !== null) {
                        if($question->image1){
                            @unlink("images/match/".$question->image1); 
                        }
                        $question->image1 = saveImage1($org_name,$this->folder,2);
                               
                    } 
                   

                    if($question->save()) {
                        return response()->json(array('status' => 200, 'success'=>  __('Label.success_edit_question') ));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=>  __('Label.error_edit_question') ));
                    }
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    
}
