<?php

namespace App\Http\Controllers\Admin;
use OneSignal;
use Validator;
use DataTables, URL, DB;
use Illuminate\Http\Request;

use App\Models\Notification;
use App\Models\General_Setting;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class NotificationController extends Controller
{

    private $folder = "/notification";

    public function index()
    {   
        try{
            return view('admin.notification.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add()
    {   
        try{
            return view('admin.notification.add');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request)
    {
        try{
            $validator = Validator::make($request->all(),[
                'headings' => 'required',
                'contents' => 'required', 
                'big_picture' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',           
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $setting = General_Setting::get();
                foreach($setting as $row){
                    if($row->key == 'onesignal_apid'){
                        $data[$row->key] =$row->value;
                    } else {
                        $data[$row->key] = "";                        
                    }
                }
                $notification = new Notification();
                $notification->app_id = "c5fada58-5fd2-4ca3-8dab-d2c368116bfc";
                $notification->included_segments = 'All';
                $notification->data = 'bar';
                $notification->headings = $request->headings;
                $notification->contents = $request->contents;

                $org_name = $request->file('big_picture');
                if ($org_name !== null) {
                    $notification->big_picture = saveImage($org_name,$this->folder);
                } 

                if($notification->save()){
                    
               \App\Notifications\SendPushnotification::dispatch($notification);
                // OneSignal::sendNotificationToAll('test' , $url = null, $data = null);
                  
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_send_notification') ));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_send_notification') ));
                }
            }
        } catch(Exception $e){
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {   
        try{
            if ($request==true) {
                $data = Notification::select('*');
                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("deleteNotification",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->addColumn('c_date', function($row){
                    $newDate = date("d-m-Y: h:m:i", strtotime($row->created_at));
                    
                    return $newDate;
                  
                })
                
                ->rawColumns(['action'])
                ->make(true);
            } else{     
                return view('admin.notification.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try{
            $notification = Notification::where('id',$id)->first();
            if ($notification->image !=null) {
                if($notification->delete()){
                    @unlink("images/notification/".$notification->image);        
                    return back()->with('success', __('Label.Notification Delete Successfully.'));   
                }
            } else {
                 if($notification->delete()){
                    return back()->with('success', __('Label.Notification Delete Successfully.'));   
                }
            }
        } catch (Exception $e) {
            return redirect('category')->with($e);
        }
    }
    public function setting(Request $request)
    {
        try{
            $setting = General_Setting::select('*')->get();
            foreach($setting as $row){
                $data[$row->key] =$row->value;
            }
            return view('admin.notification.setting',['result'=>$data,]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function settingsave(Request $request)
    {
        try{
            $data = $request->all();
            $data["onesignal_apid"] = isset($data['onesignal_apid']) ?  $data['onesignal_apid']: '';
            $data["onesignal_rest_key"] = isset($data['onesignal_rest_key']) ?  $data['onesignal_rest_key']: '';
            
            foreach ($data as $key => $value) {
                $setting = General_Setting::where('key',$key)->first();
                if (isset($setting->id)) {
                    $setting->value = $value;
                    $setting->save();
                }
            }
            return response()->json(array('status' => 200, 'success'=>__('Label.save_setting')));
        } catch(Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

}