<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use App\Models\Users;
use DataTables, URL, DB;
use Illuminate\Http\Request;
use App\Models\Pratice_Leaderborad;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class PraticeLeaderboardController extends Controller
{
    public function index()
    {   
        try{
            return view('admin.pratice_leaderboard.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data($type,Request $request)
    {
        try{
            if ($type == "all") {
                $data = Pratice_Leaderborad::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as rank'),'user_id',DB::raw('SUM(score) As total_score'))
                    ->groupBy('user_id')
                    ->with('users')
                    ->orderBy('rank','ASC')
                    ->get();

                return DataTables()::of($data)
                ->addIndexColumn()
                ->make(true);
            
            } elseif($type == "today"){
                $data = Pratice_Leaderborad::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as rank'),'user_id',DB::raw('SUM(score) As total_score'))
                    ->where('date', date("Y-m-d"))
                    ->groupBy('user_id')
                    ->with('users')
                    ->orderBy('rank','ASC')
                    ->get();

                return DataTables()::of($data)
                ->addIndexColumn()
                ->make(true);

            } elseif($type == "month"){
                $data = Pratice_Leaderborad::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as rank'),'user_id',DB::raw('SUM(score) As total_score'))
                    ->whereMonth('date', date('m'))
                    ->groupBy('user_id')
                    ->with('users')
                    ->orderBy('rank','ASC')
                    ->get();

                return DataTables()::of($data)
                ->addIndexColumn()
                ->make(true);

            } else {
                $data = Pratice_Leaderborad::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as rank'),'user_id',DB::raw('SUM(score) As total_score'))
                    ->groupBy('user_id')
                    ->with('users')
                    ->orderBy('rank','ASC')
                    ->get();

                return DataTables()::of($data)
                ->addIndexColumn()
                ->make(true);
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

}
