<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use Illuminate\Http\Request;
use App\Imports\QuestionImport;
use App\Exports\QuestionExport;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\MttRegistrationsExport;

class QuestionImportController extends Controller
{
    public function index()
    {
        try{
            return view('admin.question_import.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function export(Request $request)
    {
        try{
            return Excel::download(new QuestionExport, 'Data-Format.csv');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function import(Request $request) 
    {
        try{
            $validator = Validator::make($request->all(),[
                'import_file' => 'required|mimes:csv,txt',
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            }

            Excel::import(new QuestionImport, $request->file('import_file')->store('temp'));
            return response()->json(array('status' => 200, 'success'=> "File Upload Successfully" ));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    
}
