<?php

namespace App\Http\Controllers\Api;

use DB;
use Validator;
use App\Models\Level;
use App\Models\Users;
use App\Models\Winners;
use App\Models\Contest;
use App\Models\Question;
use Illuminate\Http\Request;
use App\Models\Contest_Report;
use App\Models\Wallet_Transaction;
use App\Http\Controllers\Controller;

class Contest_Controller extends Controller
{
    private $folder = "/user";

    public function getContest(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'list_type' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $last['status'] = 200;
                $last['message'] = __('api_msg.get_record_successfully');

                $currentDateTime = date('Y-m-d H:i:s');
                if ($request->list_type == 'ended') {
                    $data = Contest::select('*')
                        ->where('end_date', '<=', $currentDateTime)
                        ->get();
                    for ($i = 0; $i < count($data); $i++) {

                        $join_user = Wallet_Transaction::where('contest_id', $data[$i]->id)->count();
                        if ($join_user) {
                            $data[$i]->no_of_left_user = ($data[$i]->no_of_user - $join_user);
                        } else {
                            $data[$i]->no_of_left_user = $data[$i]->no_of_user;
                        }

                        $isBuy = Wallet_Transaction::where('user_id', $request->user_id)->where('contest_id', $data[$i]->id)->first();
                        if ($isBuy) {
                            $data[$i]->is_buy = 1;
                        } else {
                            $data[$i]->is_buy = 0;
                        }
                        $isPlayed = Contest_Report::where('user_id', $request->user_id)->where('contest_id', $data[$i]->id)->first();
                        if ($isPlayed) {
                            $data[$i]->is_played = 1;
                        } else {
                            $data[$i]->is_played = 0;
                        }
                    }
                    $last['result'] = $data;
                } elseif ($request->list_type == 'upcoming') {
                    $data = Contest::select('*')
                        ->where('start_date', '>=', $currentDateTime)
                        ->get();
                    for ($i = 0; $i < count($data); $i++) {

                        $join_user = Wallet_Transaction::where('contest_id', $data[$i]->id)->count();
                        if ($join_user) {
                            $data[$i]->no_of_left_user = ($data[$i]->no_of_user - $join_user);
                        } else {
                            $data[$i]->no_of_left_user = $data[$i]->no_of_user;
                        }

                        $isBuy = Wallet_Transaction::where('user_id', $request->user_id)->where('contest_id', $data[$i]->id)->first();
                        if ($isBuy) {
                            $data[$i]->is_buy = 1;
                        } else {
                            $data[$i]->is_buy = 0;
                        }
                        $isPlayed = Contest_Report::where('user_id', $request->user_id)->where('contest_id', $data[$i]->id)->first();
                        if ($isPlayed) {
                            $data[$i]->is_played = 1;
                        } else {
                            $data[$i]->is_played = 0;
                        }
                    }
                    $last['result'] = $data;
                } elseif ($request->list_type == 'live') {
                    $data = Contest::select('*')
                        ->where('start_date', '<=', $currentDateTime)
                        ->where('end_date', '>=', $currentDateTime)
                        ->get();
                    for ($i = 0; $i < count($data); $i++) {

                        $join_user = Wallet_Transaction::where('contest_id', $data[$i]->id)->count();
                        if ($join_user) {
                            $data[$i]->no_of_left_user = ($data[$i]->no_of_user - $join_user);
                        } else {
                            $data[$i]->no_of_left_user = $data[$i]->no_of_user;
                        }

                        $isBuy = Wallet_Transaction::where('user_id', $request->user_id)->where('contest_id', $data[$i]->id)->first();
                        if ($isBuy) {
                            $data[$i]->is_buy = 1;
                        } else {
                            $data[$i]->is_buy = 0;
                        }
                        $isPlayed = Contest_Report::where('user_id', $request->user_id)->where('contest_id', $data[$i]->id)->first();
                        if ($isPlayed) {
                            $data[$i]->is_played = 1;
                        } else {
                            $data[$i]->is_played = 0;
                        }
                    }
                    $last['result'] = $data;
                } else {
                    $last['result'] = [];
                }
                return $last;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function getContestLeaderBoard(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'contest_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $user_id = $request->user_id;
                $contest_id = $request->contest_id;

                $contest_leaderboard['status'] = 200;
                $contest_leaderboard['message'] = __('api_msg.get_record_successfully');

                $contestList = API_contestList($contest_id);
                if (count($contestList)) {
                    for ($i = 0; $i < count($contestList); $i++) {
                        if ($contestList[$i]->profile_img) {
                            $path = url('images/user/' . $contestList[$i]->profile_img);
                            $contestList[$i]->profile_img = $path;
                        } else {
                            $contestList[$i]->profile_img = "";
                        }

                        $contestList[$i]->user_total_score = isset($contestList[$i]->user_total_score) ? $contestList[$i]->user_total_score : 0;
                    }
                    $contest_leaderboard['result'] = $contestList;
                } else {
                    $contest_leaderboard['result'] = [];
                }

                $contestListUser = API_contestListUser($user_id, $contest_id);
                if ($contestListUser) {
                    $path = url('images/user/' . $contestListUser->profile_img);
                    $contestListUser->profile_img = $path;
                    $contest_leaderboard['user'] = [$contestListUser];
                } else {
                    $contest_leaderboard['user'] = [];
                }
                return $contest_leaderboard;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function joinContest(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'contest_id' => 'required',
                'coin' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $user_id = $request->user_id;
                $contest_id = $request->contest_id;
                $coin = $request->coin;

                $contest = Contest::where('id', $request->contest_id)->first();
                $JoinUser = Wallet_Transaction::select('*')->where('contest_id', $request->contest_id)->get();

                if (count($JoinUser) < $contest->no_of_user) {
                    $chackPoint = Users::where('total_points', '>=', $coin)->where('id', $user_id)->first();
                    if ($chackPoint) {
                        $data = new Wallet_Transaction();
                        $data->user_id = $user_id;
                        $data->contest_id = $contest_id;
                        $data->coin = $coin;
                        if ($data->save()) {
                            $change = Users::where('id', $user_id)->first();
                            $sum = $change->total_points - $coin;
                            $change->total_points = $sum;
                            $change->save();
                        }
                        $msg['status'] = 200;
                        $msg['message'] = __('api_msg.you_have_successfully_joined');
                        return $msg;
                    } else {
                        $msg['status'] = 400;
                        $msg['message'] = __('api_msg.please_recharge_your_wallet');
                        return $msg;
                    }
                } else {
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.Contest_is Full');
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function upcomingContest(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                if ($request->user_id) {
                    $user_id = $request->user_id;
                } else {
                    $user_id = "";
                }

                $user = Wallet_Transaction::where('user_id', $user_id)->first();
                if ($user) {
                    $contest = Contest::where('id', $user->contest_id)->where('start_date', '>=', date("Y-m-d H:i:s"))->first();
                    if ($contest) {
                        $isPlayed = Contest_Report::where('user_id', $user->user_id)->where('contest_id', $user->contest_id)->first();
                        $contest->is_buy = 1;
                        if ($isPlayed && $contest) {
                            $contest->is_played = 1;
                        } else {
                            $contest->is_played = 0;
                        }
                        return $contest;
                    } else {
                        $data['status'] = 400;
                        $data['message'] = __('api_msg.record_not_found');
                        return $data;
                    }
                } else {
                    $data['status'] = 400;
                    $data['message'] = __('api_msg.record_not_found');
                    return $data;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function get_review_question_by_contest_id(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'contest_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $user_id = $request->user_id;
                $contest_id = $request->contest_id;

                $msg['status'] = 200;
                $msg['message'] = __('api_msg.get_record_successfully');

                $Rdata = Contest_Report::select('id', 'user_id', 'contest_id', 'total_questions', 'questions_attended', 'correct_answers', 'score', 'date', 'is_unlock', 'created_at', 'updated_at', 'status', 'question_json')
                    ->where('user_id', $user_id)
                    ->where('contest_id', $contest_id)
                    ->first();
                if ($Rdata) {
                    $data['id'] = $Rdata->id;
                    $data['user_id'] = $Rdata->user_id;
                    $data['contest_id'] = $Rdata->contest_id;
                    $data['total_questions'] = $Rdata->total_questions;
                    $data['questions_attended'] = $Rdata->questions_attended;
                    $data['correct_answers'] = $Rdata->correct_answers;
                    $data['score'] = $Rdata->score;
                    $data['date'] = $Rdata->date;
                    $data['is_unlock'] = $Rdata->is_unlock;
                    $data['status'] = $Rdata->status;
                    $contest_name = Contest::where('id', $Rdata->contest_id)->first();
                    if ($contest_name) {
                        $data['name'] = $contest_name->name;
                    }
                    $data['created_at'] = $Rdata->created_at;
                    $data['updated_at'] = $Rdata->updated_at;

                    $Json = json_decode($Rdata->question_json, true);

                    foreach ($Json as $key => $value) {
                        $question = Question::where('id', $value['id'])->first();
                        if ($question->id == $value['id']) {
                            if ($question->image) {
                                $path = url('images/question/' . $question->image);
                                $question->image = $path;
                            } else {
                                $question->image = "";
                            }
                            $question['user_ansewer'] = $value['user_answer'];
                            $Uquestion[] = $question;
                        } else {
                            $Uquestion = "";
                        }
                    }
                    $data['question_list'] = $Uquestion;

                    $msg['result'] = $data;
                } else {
                    $msg['status'] = 400;
                    $msg['message'] = __('api_msg.record_not_found');
                }
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function get_winner_by_contest(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'contest_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $contest_id = $request->contest_id;

                $data = Winners::where('contest_id', $contest_id)->orderBy('rank', 'asc')->get();
                if ($data) {
                    for ($i = 0; $i < count($data); $i++) {
                        $user = Users::where('id', $data[$i]->user_id)->first();
                        if ($user) {
                            $data[$i]->fullname = $user->fullname;
                        }
                    }
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.get_record_successfully');
                    $msg['result'] = $data;
                } else {
                    $msg['status'] = 400;
                    $msg['message'] = __('api_msg.record_not_found');
                }
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}