<?php

namespace App\Http\Controllers\Api;
use Illuminate\Pagination\Paginator;
use Validator;
use App\Models\Level;
use App\Models\Category;
use App\Models\StudySet;
use App\Models\Bookmark;
use App\Models\Studyset_status;
use App\Models\Sets;
use App\Models\SetsCompleted;
use DataTables, URL, DB;
use App\Models\Question;
use App\Models\Earnpoints;
use App\Models\Users;
use App\Models\StudysetViews;
use Illuminate\Http\Request;
use App\Models\Classification;
use App\Models\Pratice_Question;
use App\Models\MatchMaking;
use App\Models\QuestioLeaderboard;
use App\Http\Controllers\Controller;
use Carbon\Carbon;

class Level_Controller extends Controller
{
    private $folder = "/sets";
    public function get_level(Request $request)
    {   
        try {
            $validator = Validator::make($request->all(), [
                'category_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $level = Level::orderBy('level_order','asc')->get();
                $category = category::get();

                if ($level){
                    $size = sizeof($level);

                    $result['status'] = 200;
                    $result['message'] = __('api_msg.get_record_successfully');
                    foreach ($category as $key => $value) {
                        if($value->id == $request->category_id){
                            $result['result'] = $level;
                            for ($i = 0; $i < $size; $i++) {
                                $level[$i]->category_id = $value->id;
                                if($i == 0){
                                    $level[$i]->is_unlock = 1;
                                    $lock = Question_Is_unlock($request->user_id, $request->category_id, $level[$i]->id);
                                    if ($lock && $lock->correct_answers >= $lock->win_question_count ){
                                        if($i+1 < $size){
                                            $level[$i]->is_unlock = 1;
                                            $level[$i+1]->is_unlock = 1;
                                        }
                                    } else {
                                        if($i+1 < $size){
                                            $level[$i+1]->is_unlock = 0;
                                        }
                                    }
                                } else {
                                    $lock = Question_Is_unlock($request->user_id, $request->category_id, $level[$i]->id);
                                    if ($lock && $lock->correct_answers >= $lock->win_question_count ){
                                        if($i+1 < $size){
                                            $level[$i]->is_unlock = 1;
                                            $level[$i+1]->is_unlock = 1;
                                        }
                                    } else {
                                        if($i+1 < $size){
                                            $level[$i+1]->is_unlock = 0;
                                        }
                                    }
                                } 
                            }
                            break;
                        } else {
                            $result['result'] = [];
                        }
                    }
                    return $result;
                } else {
                    $result['status'] = 200;
                    $result['message'] = __('api_msg.get_record_successfully');
                    $result['result'] = [];
                    return $result;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function get_pratice_level(Request $request)
    {
        try {
            $level = Level::orderBy('level_order','asc')->get();
            if ($level){
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = $level;
                return $result;
            } else {
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = [];
                return $result;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function getQuestionLevelMaster()
    {
        try {
            $data = Classification::all();
            if ($data) {
                $level_master['status'] = 200;
                $level_master['message'] = __('api_msg.get_record_successfully');
                $level_master['result'] = $data;
                return $level_master;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.no_record');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function category(Request $request)
    {
        $perPage=100;
        $today = Carbon::now()->toDateString();
        $yesterday = Carbon::yesterday()->toDateString(); 
        $endDate = Carbon::now()->toDateString(); // Get the current date
        $startDate = Carbon::now()->subWeek()->toDateString(); 
        $endMonthDate = Carbon::now()->startOfMonth()->subDay()->toDateString(); // Get the last day of the previous month
        $startMonthDate = Carbon::now()->startOfMonth()->subMonth()->toDateString();
        try {
            if($request->search){
                if($request->isFilter){
                    \Log::info('inside filter');
                    $filter=$request->filter;
                    switch ($filter) {
                        case 'AtoZ':
                            $category = Category::where('name','like',"%{$request->search}%")->orderBy('name', 'asc')->get();
                            break;
                        case 'ZtoA':
                            $category= Category::where('name','like',"%{$request->search}%")->orderBy('name', 'desc')->get();
                            break;
                      
                        default:
                      
                            // Handle unknown filter or provide a default action
                    }
                }else{

                    $category = Category::where('name','like',"%{$request->search}%")->get();
                }
       
            }else{
                if($request->isFilter){
                    \Log::info('inside filter');
                    $filter=$request->filter;
                    switch ($filter) {
                        case 'AtoZ':
                            $category = Category::orderBy('name', 'asc')->get();
                            break;
                        case 'ZtoA':
                            $category = Category::orderBy('name', 'desc')->get();
                            break;
                      
                        default:
                      
                            // Handle unknown filter or provide a default action
                    }
                }else{

                    $category = Category::get();
                }
              
            }
            if ($category) {
                foreach($category as $cat){
                    $scount=StudySet::where('category_id', $cat->id)->count();
                    $cat->study_count=$scount;
                    if($cat->image){
                        $cat->image = url('images/category/' . $cat->image);      
                        }   else{
                            $cat->image=NULL;
                        }       
                }
                // $size = sizeof($category);
                // for ($i = 0; $i < $size; $i++) {

                //     $path = url('images/category/' . $category[$i]->image);
                //     $category[$i]->image = $path;
                // }
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = $category;
                return $result;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.record_not_found');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function getSets(Request $request)
    {
       
   
        try {
           if($request->id){
            $record = StudysetViews::where('studyset_id',$request->id)->first();
           }
           if($request->slug){
            $stset = StudySet::where('slug',$request->slug)->first();
            $request->id = $stset->id;
            $record = StudysetViews::where('studyset_id',$request->id)->first();
           }

            if (!$record) {
                $record =  new  StudysetViews();
                $record->studyset_id=$request->id;
            }
        
            // Increment the value you want to update (e.g., 'count' column)
            $record->views++;
           
        
            // Save the updated record
            $record->save();
                
            $sets = Sets::where('studyset_id', $request->id)->get();
            $studyset = StudySet::where('id', $request->id)->first();
            $quiz = Question::where('studyset_id', $request->id)->get();
            $practice = Pratice_Question::where('studyset_id', $request->id)->get();
            $match = MatchMaking::where('studyset_id', $request->id)->get();
            if($request->userid){
                $bookmark=Bookmark::where('user_id',$request->userid)->where('studyset_id', $request->id)->first();
            }
           
            // foreach($secondary as $sec){
            //     $username= Users::where('id',$sec->posted_by )->first();
            //     $count=Sets::where('studyset_id', $sec->id)->count();
            //     $sec->posted_by=$username->fullname;
            //     if($username->profile_img){
            //         $path = url('images/user/' . $username->profile_img);                
            //         $sec->profile_img = $path;
            //         }
            //     $sec->count= $count;
                
            // }
            // $size = sizeof($match);
            // for ($i = 0; $i < $size; $i++) {

            //     $path = url('images/category/' . $match[$i]->image);
            //     $category[$i]->image = $path;
            // }
            $username= Users::where('id',$studyset->posted_by )->first();               
        
            $studyset->count=count($sets);
            $studyset->posted_by=$username->fullname;
            if($username->profile_img){
            $path = url('images/user/' . $username->profile_img);                
            $studyset->profile_img = $path;
            }
          
            if ($sets) {
               
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['studyset'] = $studyset;
                $result['sets'] = $sets;
                $result['quiz'] = $quiz;
                $result['practice'] = $practice;
                $result['match'] = $match;
               if($request->userid){
                if(!$bookmark){
                    $result['bookmark'] = false;
                }else{
                    $result['bookmark'] = true;
                }
            }
                
                return $result;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.record_not_found');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function get_singleset(Request $request)
    {
        try {
           
            $sets = Sets::where('studyset_id', $request->id)->get();
            $studyset = StudySet::where('id', $request->id)->first();          
              foreach($sets  as $sec){
                if($sec->cover_image!=null){ 
                    $sec->cover_image= url('images/studyset/' . $sec->cover_image);  
                }
                if($sec->main_image!=null){ 
                $sec->main_image= url('images/studyset/' . $sec->main_image);  
                }
                if( $sec->icon_image!=null){
                $sec->icon_image= url('images/studyset/' . $sec->icon_image);  
                }  
              }
        
            $username= Users::where('id',$studyset->posted_by )->first();           
        
           
            $studyset->posted_by=$username->fullname;
          
            if ($studyset) {
               
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['studyset'] = $studyset;
                $result['sets'] = $sets;
                $result['quiz'] = [];
                $result['practice'] = [];
                $result['match'] = [];
                
                    $result['bookmark'] = true;
            
                
                return $result;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.record_not_found');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function bookMark(Request $request){

        $isExist= Bookmark::where('user_id', $request->userid)
        ->where('studyset_id', $request->studysetid)->first();

          
        if (!$isExist) {
               $bookmark=new Bookmark();
               $bookmark->user_id= $request->userid;
               $bookmark->studyset_id= $request->studysetid;
               $bookmark->save();              
                $data['status'] = 200;             
                $data['message'] = 'Book Mark saved Successfully';               
                $data['result'] = [];
                return $data;
        } else {
            $bookmark=  Bookmark::where('user_id', $request->userid)->where('studyset_id', $request->studysetid)->delete();           
           
           if($bookmark){
            $data['status'] = 200;             
             $data['message'] = 'Bookmark Removed';               
             $data['result'] = [];
             return $data;
           }else{
            $data['status'] = 400;             
            $data['message'] = 'Something Wrong';               
            $data['result'] = [];
            return $data;
           }

        }
    }


    public function create_set(Request $request)
    {   
        \Log::info($request);
        if($request->id){
            $studyset =  StudySet::where('id',$request->id)->first();
            $studyset->name =$request->setname;
            $studyset->category_id =$request->category;
            $studyset->posted_by =$request->userId;          
            if ($request->file('studset_image')) {
   
                if($studyset->main_image!=null){
                    @unlink("images/studyset/".$studyset->main_image);   
                   }
                   $uploadedImage = $request->file('studset_image');
                   $imageName = time() . '.' . $uploadedImage->getClientOriginalExtension();
                   $uploadedImage->move(public_path('images/studyset/'), $imageName);
                   // $org_name = $request->file('studset_image');
                   // $fin_img =  saveImage($org_name, $this->folder);
                   $studyset->main_image =  $imageName;
            } 
            $studyset->save();

            $sets=Sets::where('studyset_id',$request->id)->get();
          
            // foreach($request->terms as $term){
            //     $set=new Sets();
            //     $set->question=$term;
            //     $set->description=$term;
            //     $set->studyset_id=$studyset->id;        
            //     $set->save();
            // }
            if($request->hasFile('files')){
            $files=$request->file('files');
            }
            for($i=0; $i< count($request->terms); $i++){
               
                // \Log::info($files[$i]);
             
                $sets[$i]->question=$request->terms[$i];
                $sets[$i]->description=$request->defs[$i];
                $sets[$i]->studyset_id=$studyset->id;    
            
                if($request->hasFile('files')){
                    if (array_key_exists($i, $files))  {
                
                  
                    $org_name =$files[$i];
                    $imageName = time(). '.'.$i.'.'.$org_name->getClientOriginalExtension();
                    $org_name->move(public_path('images/sets/'), $imageName);
                    $sets[$i]->image = $imageName; 
                    
           
                    // \Log::info($org_name);
                }    
            
            }
            if($request->hasFile('files1')){
                $files1=$request->file('files1');
                if (array_key_exists($i, $files1))  {       
                    $org_name1 =$files1[$i];
                    $imageName1 = time(). '.' .  rand(1, 1000) .  $org_name1->getClientOriginalExtension();
                    $org_name1->move(public_path('images/sets/'), $imageName1);
                    $sets[$i]->image1 = $imageName1; 
                }  
            }
      
                $sets[$i]->save();
            }
        }else{        

    $studyset = new StudySet();
    $studyset->name =$request->setname;
    $studyset->category_id =$request->category;
    $studyset->posted_by =$request->userId;
    $studyset->reward_type =3;
    if ($request->file('studset_image')) {
        $uploadedImage = $request->file('studset_image');
        $imageName = time() . '.' . $uploadedImage->getClientOriginalExtension();
        $uploadedImage->move(public_path('images/studyset/'), $imageName);
    
        $studyset->main_image =  $imageName;
    }
    $studyset->save();
    if($request->hasFile('files')){
        $files=$request->file('files');
        }
   for($i=0; $i< count($request->terms); $i++){
        $set=new Sets();
       
        $set->question=$request->terms[$i];
        $set->description=$request->defs[$i];
        $set->studyset_id=$studyset->id;  
          if($request->hasFile('files')){
        if (array_key_exists($i, $files))  {       
         
            $org_name =$files[$i];
            $imageName = time(). '.'.$i. $org_name->getClientOriginalExtension();
           
            $org_name->move(public_path('images/sets/'), $imageName);
             $set->image = $imageName;          

          
        }   
        $files1=$request->file('files1');
        if (array_key_exists($i, $files1))  {       
            $org_name1 =$files1[$i];
            $imageName1 = time(). '.' .  rand(1, 1000) .  $org_name1->getClientOriginalExtension();
            $org_name1->move(public_path('images/sets/'), $imageName1);
            $set->image1 = $imageName1;    
        }  
        
    } 

    
        $set->save();
    }
}

    if( $studyset){
            $data['status'] = 200;                        
            $data['message'] = 'Successfully submitted';
             $data['result'] = [];
                }else{
                $data['status'] = 400;
                 $data['message'] = 'Study set submission failed';
                  $data['result'] = []; 
                 }
        return $data;
    }
    public function getHome(Request $request)
    {
        try {
            $category = Category::get();
            $primary = StudySet::where('featured', 1)->where('featured', 1)->get();
          
            $recent = StudySet::where('status', 1)->orderBy('id', 'desc')->take(10) ->get();
            $all = StudySet::where('status', 1)->orderBy('id', 'asc')->take(10) ->get();

            $table1 = 'studyset';
            $table2 = 'views_studysets';
            $secondary = StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
            ->orderBy("$table2.views", "desc")    
            ->where("$table1.status", 1)    
            ->select("$table1.*")  
            ->take(10) 
            ->get();

        
             if( $request->user_id){
            $userdata = Users::where('id', $request->user_id)->first();         
            $count= SetsCompleted::where('user_id', $request->user_id)->count();
            $userdata->sets_completed=$count;
            if ($userdata != null) {
                if ($userdata->profile_img) {
                    $path = url('images/user/' . $userdata->profile_img);
                    $userdata->profile_img = $path;
                } else {
                    $userdata->profile_img = NULL;
                } 
            }
        }else{
            $userdata=NULL;
        }

        
              
            foreach($category as $cat){
                $scount=StudySet::where('category_id', $cat->id)->count();
                $cat->study_count=$scount;
                if($cat->image){
                $cat->image = url('images/category/' . $cat->image);      
                }   else{
                    $cat->image=NULL;
                }       
               
            }
            foreach($recent as $sec){
                $username= Users::where('id',$sec->posted_by )->first();
                $count=Sets::where('studyset_id', $sec->id)->count();
                $imgcount=Sets::where('image','!=', NULL)->where('studyset_id', $sec->id)->count();
                $sec->posted_by=$username->fullname;
                if($username->profile_img){
                    $path = url('images/user/' . $username->profile_img);                
                    $sec->profile_img = $path;
                    }
                $setscount=Studyset_status::where('studyset_id', $sec->id)->where('status','completed')->count();
                $sec->count= $count;
                $sec->completed_sets= $setscount;
                $sec->imgcount=$imgcount;
                if($sec->cover_image!=null){ 
                    $sec->cover_image= url('images/studyset/' . $sec->cover_image);  
                }
                if($sec->main_image!=null){ 
                $sec->main_image= url('images/studyset/' . $sec->main_image);  
                }
                if( $sec->icon_image!=null){
                $sec->icon_image= url('images/studyset/' . $sec->icon_image);  
                }  
                
            }
            foreach($all as $sec){
                $username= Users::where('id',$sec->posted_by )->first();
                $count=Sets::where('studyset_id', $sec->id)->count();
                $imgcount=Sets::where('image','!=', NULL)->where('studyset_id', $sec->id)->count();
                $sec->posted_by=$username->fullname;
                if($username->profile_img){
                    $path = url('images/user/' . $username->profile_img);                
                    $sec->profile_img = $path;
                    }
                $setscount=Studyset_status::where('studyset_id', $sec->id)->where('status','completed')->count();
                $sec->count= $count;
                $sec->completed_sets= $setscount;
                $sec->imgcount=$imgcount;
                if($sec->cover_image!=null){ 
                    $sec->cover_image= url('images/studyset/' . $sec->cover_image);  
                }
                if($sec->main_image!=null){ 
                $sec->main_image= url('images/studyset/' . $sec->main_image);  
                }
                if( $sec->icon_image!=null){
                $sec->icon_image= url('images/studyset/' . $sec->icon_image);  
                }  
                
            }
         
            foreach($secondary as $sec){
                $username= Users::where('id',$sec->posted_by )->first();
                $count=Sets::where('studyset_id', $sec->id)->count();
                $imgcount=Sets::where('image','!=', NULL)->where('studyset_id', $sec->id)->count();
                $sec->posted_by=$username->fullname;
                if($username->profile_img){
                    $path = url('images/user/' . $username->profile_img);                
                    $sec->profile_img = $path;
                    }
                $setscount=Studyset_status::where('studyset_id', $sec->id)->where('status','completed')->count();
                $sec->count= $count;
                $sec->completed_sets= $setscount;
                $sec->imgcount=$imgcount;
                if($sec->cover_image!=null){ 
                    $sec->cover_image= url('images/studyset/' . $sec->cover_image);  
                }
                if($sec->main_image!=null){ 
                $sec->main_image= url('images/studyset/' . $sec->main_image);  
                }
                if( $sec->icon_image!=null){
                $sec->icon_image= url('images/studyset/' . $sec->icon_image);  
                }  
                
            }
            foreach($primary as $sec){
                $username= Users::where('id',$sec->posted_by )->first();               
                $count=Sets::where('studyset_id', $sec->id)->count();
                $imgcount=Sets::where('image','!=', NULL)->where('studyset_id', $sec->id)->count();
                $sec->posted_by=$username->fullname;
                if($username->profile_img){
                $path = url('images/user/' . $username->profile_img);                
                $sec->profile_img = $path;
                }
                $setscount=Studyset_status::where('studyset_id', $sec->id)->count();
                $sec->count= $count;
                $sec->completed_sets= $setscount;
                $sec->imgcount=$imgcount;
                
                if($sec->cover_image!=null){ 
                    $sec->cover_image= url('images/studyset/' . $sec->cover_image);  
                }
                if($sec->main_image!=null){ 
                $sec->main_image= url('images/studyset/' . $sec->main_image);  
                }
                if( $sec->icon_image!=null){
                $sec->icon_image= url('images/studyset/' . $sec->icon_image);  
                }
            }
            if ($category) {
               
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = $category;
                $result['primary'] = $primary;
                $result['secondary'] = $secondary;
                $result['recent'] = $recent;
                $result['all'] = $all;
                $result['user'] = $userdata;
              
                return $result;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.record_not_found');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function getSearch(Request $request)
    {
        $perPage=10;
        $offset = ($request->page - 1) * $perPage;
        
        $today = Carbon::now()->toDateString();
        $yesterday = Carbon::yesterday()->toDateString(); 
        $endDate = Carbon::now()->toDateString(); // Get the current date
        $startDate = Carbon::now()->subWeek()->toDateString(); 
        $endMonthDate = Carbon::now()->startOfMonth()->subDay()->toDateString(); // Get the last day of the previous month
        $startMonthDate = Carbon::now()->startOfMonth()->subMonth()->toDateString();
        \Log::info($request->type);
        try {

            if($request->has('search')){
             
                $primary = StudySet::where('name','like',"%{$request->search}%")->where('status', 1)->paginate($perPage);
            }
           else if($request->type){         
            if($request->type=='category'){
                \Log::info($request->slug);
                if($request->slug){
                    $cat=Category::where('slug',  $request->slug)->first();
                    $request->id =$cat->id;
                    }
                if($request->isFilter){
                    \Log::info('inside filter');
                    $filter=$request->filter;
                    switch ($filter) {
                        case 'AtoZ':
                            $primary = StudySet::where('status', 1)->where('category_id', $request->id)->orderBy('name', 'asc')->paginate($perPage);
                            break;
                        case 'ZtoA':
                            $primary = StudySet::where('status', 1)->where('category_id', $request->id)->orderBy('name', 'desc')->paginate($perPage);
                            break;
                        case 'today':
                            $primary = StudySet::where('status', 1)->where('category_id', $request->id)->whereDate('created_at', $today)->paginate($perPage);
                            break;
                        case 'yesterday':
                            $primary = StudySet::where('status', 1)->where('category_id', $request->id)->whereDate('created_at', $yesterday)->paginate($perPage);
                            break;
                        case 'HtoL':
                            $primary = StudySet::where('status', 1)->where('category_id', $request->id)->orderBy('reward_points', 'desc')->paginate($perPage);
                            break;
                        case 'LtoH':
                            $primary = StudySet::where('status', 1)->where('category_id', $request->id)->orderBy('reward_points', 'asc')->paginate($perPage);
                            break;

                        case 'lastweek':
                            $primary = StudySet::where('status', 1)->where('category_id', $request->id)->whereBetween('created_at', [$startDate, $endDate])->paginate($perPage);
                            break;
                            
                        case 'lastmonth':
                            $primary = StudySet::where('status', 1)->where('category_id', $request->id)->whereBetween('created_at', [$startMonthDate, $endMonthDate])->paginate($perPage);
                            break;
                            case 'custom':
                                $primary = StudySet::where('status', 1)->where('category_id', $request->id)->whereDate('created_at', $request->custom)->paginate($perPage);
                                break;
                        default:
                        $primary = StudySet::where('status', 1)->where('category_id', $request->id)->where('name','like',"%{$request->filter}%")->paginate($perPage);
                            // Handle unknown filter or provide a default action
                    }
              
                }else{
                $primary = StudySet::where('status', 1)->where('category_id', $request->id)->paginate($perPage);
                }
            }
            if($request->type=='primary'){
                if($request->isFilter){
                    \Log::info('inside filter');
                    $filter=$request->filter;
                    switch ($filter) {
                        case 'AtoZ':
                            $primary = StudySet::where('status', 1)->where('featured', 1)->orderBy('name', 'asc')->paginate($perPage);
                            break;
                        case 'ZtoA':
                            $primary = StudySet::where('status', 1)->where('featured', 1)->orderBy('name', 'desc')->paginate($perPage);;
                            break;
                        case 'today':
                            $primary = StudySet::where('status', 1)->where('featured', 1)->whereDate('created_at', $today)->paginate($perPage);
                            break;
                        case 'yesterday':
                            $primary = StudySet::where('status', 1)->where('featured', 1)->whereDate('created_at', $yesterday)->paginate($perPage);
                            break;
                        case 'HtoL':
                            $primary = StudySet::where('status', 1)->where('featured', 1)->orderBy('reward_points', 'desc')->paginate($perPage);
                            break;
                        case 'LtoH':
                            $primary = StudySet::where('status', 1)->where('featured', 1)->orderBy('reward_points', 'asc')->paginate($perPage);
                            break;

                        case 'lastweek':
                            $primary = StudySet::where('status', 1)->where('featured', 1)->whereBetween('created_at', [$startDate, $endDate])->paginate($perPage);
                            break;
                            
                        case 'lastmonth':
                            $primary = StudySet::where('status', 1)->where('featured', 1)->whereBetween('created_at', [$startMonthDate, $endMonthDate])->paginate($perPage);
                            break;
                            case 'custom':
                                $primary = StudySet::where('status', 1)->where('featured', 1)->whereDate('created_at', $request->custom)->paginate($perPage);
                                break;
                        default:
                        $primary = StudySet::where('status', 1)->where('featured', 1)->where('name','like',"%{$request->filter}%")->paginate($perPage);
                            // Handle unknown filter or provide a default action
                    }
              
                }else{
                $primary = StudySet::where('status', 1)->where('featured', 1)->paginate($perPage);
                }
            }
            if($request->type=='hot'){
                $table1 = 'studyset';
                $table2 = 'views_studysets';
                if($request->isFilter){
                    \Log::info('inside filter');
                    $filter=$request->filter;
                    switch ($filter) {
                        case 'AtoZ':
                            $primary =  StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                            ->where("$table1.status", 1)->orderBy("$table1.name", 'asc')
                            ->select("$table1.*")->paginate($perPage);
                            break;
                        case 'ZtoA':
                            $primary =  StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                            ->where("$table1.status", 1)->orderBy("$table1.name", 'desc')->select("$table1.*")->paginate($perPage);
                            break;
                        case 'today':
                            $primary =  StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                           ->where("$table1.status", 1)->whereDate("$table1.created_at", $today)->select("$table1.*")->paginate($perPage);;
                            break;
                        case 'yesterday':
                            $primary =  StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                           ->where("$table1.status", 1)->whereDate("$table1.created_at", $yesterday)->select("$table1.*")->paginate($perPage);
                            break;
                        case 'HtoL':
                            $primary = StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                           ->where("$table1.status", 1)->orderBy("$table1.reward_points", 'desc')->select("$table1.*")->paginate($perPage);
                            break;
                        case 'LtoH':
                            $primary =  StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                          ->where("$table1.status", 1)->orderBy("$table1.reward_points", 'asc')->select("$table1.*")->paginate($perPage);
                            break;

                        case 'lastweek':
                            $primary = StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                           ->where("$table1.status", 1)->whereBetween("$table1.created_at", [$startDate, $endDate])->select("$table1.*")->paginate($perPage);
                            break;
                            
                        case 'lastmonth':
                            $primary =  StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                           ->where("$table1.status", 1)->whereBetween("$table1.created_at", [$startMonthDate, $endMonthDate])->select("$table1.*")->paginate($perPage);
                            break;
                            case 'custom':
                                $primary = StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                               ->where("$table1.status", 1)->whereDate("$table1.created_at", $request->custom)->select("$table1.*")->paginate($perPage);
                                break;
                        default:
                        $primary =StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                        ->orderBy("$table2.views", "desc")->where("$table1.status", 1)->where("$table1.name",'like',"%{$request->filter}%")->select("$table1.*")->paginate($perPage);
                            // Handle unknown filter or provide a default action
                    }
              
                }else{
                $primary = StudySet::join($table2, "$table1.id", "=", "$table2.studyset_id")            
                ->orderBy("$table2.views", "desc")->where("$table1.status", 1)->select("$table1.*")->paginate($perPage);
                }
              
            }
            if($request->type=='recent'){
                if($request->isFilter){
                    \Log::info('inside recent');
                    $filter=$request->filter;
                    switch ($filter) {
                        case 'AtoZ':
                            $primary = StudySet::where('status', 1)->orderBy('name', 'asc')->paginate($perPage); 
                            break;
                        case 'ZtoA':
                            $primary = StudySet::where('status', 1)->orderBy('name', 'desc')->paginate($perPage); 
                            break;
                        case 'today':
                            $primary = StudySet::where('status', 1)->whereDate('created_at', $today)->paginate($perPage);
                            break;
                        case 'yesterday':
                            $primary = StudySet::where('status', 1)->whereDate('created_at', $yesterday)->paginate($perPage);
                            break;
                        case 'HtoL':
                            $primary = StudySet::where('status', 1)->orderBy('reward_points', 'desc')->paginate($perPage);
                            break;
                        case 'LtoH':
                            $primary = StudySet::where('status', 1)->orderBy('reward_points', 'asc')->paginate($perPage);
                            break;

                        case 'lastweek':
                            $primary = StudySet::where('status', 1)->whereBetween('created_at', [$startDate, $endDate])->paginate($perPage);
                            break;
                            
                        case 'lastmonth':
                            $primary = StudySet::where('status', 1)->whereBetween('created_at', [$startMonthDate, $endMonthDate])->paginate($perPage);
                            break;
                            case 'custom':
                                $primary = StudySet::where('status', 1)->whereDate('created_at', $request->custom)->paginate($perPage);
                                break;
                        default:
                        $primary = StudySet::where('status', 1)->where('name','like',"%{$request->filter}%")->paginate($perPage);
                            // Handle unknown filter or provide a default action
                    }
              
                }else{
                $primary = StudySet::where('status', 1)->orderBy('id', 'desc')->paginate($perPage);
                }
            }


            }else{
                \Log::info($request);
                if($request->isFilter){
                    \Log::info('inside All');
                    $filter=$request->filter;
                    switch ($filter) {
                        case 'AtoZ':
                            $primary = StudySet::where('status', 1)->orderBy('name', 'asc')->paginate($perPage);
                            break;
                        case 'ZtoA':
                            $primary = StudySet::where('status', 1)->orderBy('name', 'desc')->paginate($perPage);
                            break;
                        case 'today':
                            $primary = StudySet::where('status', 1)->whereDate('created_at', $today)->paginate($perPage);
                            break;
                        case 'yesterday':
                            $primary = StudySet::where('status', 1)->whereDate('created_at', $yesterday)->paginate($perPage);
                            break;
                        case 'HtoL':
                            $primary = StudySet::where('status', 1)->orderBy('reward_points', 'desc')->paginate($perPage);
                            break;
                        case 'LtoH':
                            $primary = StudySet::where('status', 1)->orderBy('reward_points', 'asc')->paginate($perPage);
                            // $currentPage = Paginator::resolveCurrentPage($request->page);
                           
                            //  $paginatedItems = $primary->slice(($currentPage - 1) * $perPage, $perPage)->all();
                            //  $primary = new \Illuminate\Pagination\LengthAwarePaginator(
                            //     $paginatedItems, // The paginated items
                            //     count($primary), // Total number of items
                            //     $perPage, // Items per page
                            //     $currentPage, // Current page
                            //     ['path' => Paginator::resolveCurrentPath()] // Additional options if needed
                            // );
                         
                            break;

                        case 'lastweek':
                            $primary = StudySet::where('status', 1)->whereBetween('created_at', [$startDate, $endDate])->paginate($perPage);
                            break;
                            
                        case 'lastmonth':
                            $primary = StudySet::where('status', 1)->whereBetween('created_at', [$startMonthDate, $endMonthDate])->paginate($perPage);
                            break;
                        case 'custom':
                            $primary = StudySet::where('status', 1)->whereDate('created_at', $request->custom)->paginate($perPage);
                            break;
                        default:
                        $primary = StudySet::where('status', 1)->where('name','like',"%{$request->filter}%")->paginate($perPage);
                            // Handle unknown filter or provide a default action
                    }
              
                }else{
                    $primary = StudySet::where('status', 1)->paginate($perPage); 
                    
                }
            }
           
          

           
            foreach($primary as $sec){
                $username= Users::where('id',$sec->posted_by )->first();               
                $count=Sets::where('studyset_id', $sec->id)->count();
                $setscount=Studyset_status::where('studyset_id', $sec->id)->where('status','completed')->count();
              
                $sec->completed_sets= $setscount;
                $imgcount=Sets::where('image','!=', NULL)->where('studyset_id', $sec->id)->count();
                $sec->posted_by=$username->fullname;
                if($username->profile_img){
                $path = url('images/user/' . $username->profile_img);                
                $sec->profile_img = $path;
                }
                \Log::info($sec->category_id);
                $username= Category::where('id',$sec->category_id)->first();  
                if($username){
                    $path = url('images/category/' . $username->image);                
                    $sec->category_image = $path;
                    }
                $sec->count= $count;
                $sec->imgcount=$imgcount;
                if($sec->cover_image!=null){ 
                    $sec->cover_image= url('images/studyset/' . $sec->cover_image);  
                }
                if($sec->main_image!=null){ 
                $sec->main_image= url('images/studyset/' . $sec->main_image);  
                }
                if( $sec->icon_image!=null){
                $sec->icon_image= url('images/studyset/' . $sec->icon_image);  
                }  
              

            }
            if ($primary) {
               
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = $primary->items();       
                $result['total_pages'] = $primary->lastPage();     
                  
                
                return $result;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.record_not_found');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function getbookMark(Request $request){
        try {
            if($request->type=='bookmark'){
            $bookmarks=Bookmark::where('user_id',  $request->userid)->get('studyset_id');
            $handymans=array();
            foreach($bookmarks as $book){
                $primary = StudySet::where('status', 1)->where('id', $book->studyset_id)->first();
                array_push($handymans,$primary);
                // \Log::info($book->studyset_id);
            }
            foreach($handymans as $sec){
                $username= Users::where('id',$sec->posted_by )->first();               
                $count=Sets::where('studyset_id', $sec->id)->count();
                $setscount=Studyset_status::where('studyset_id', $sec->id)->where('status','completed')->count();              
                $sec->completed_sets= $setscount;
                $imgcount=Sets::where('image','!=', NULL)->where('studyset_id', $sec->id)->count();
                $sec->posted_by=$username->fullname;
                if($username->profile_img){
                $path = url('images/user/' . $username->profile_img);                
                $sec->profile_img = $path;
                }
                $sec->count= $count;
                $sec->imgcount=$imgcount;

            }
        }
        if($request->type=='pending'){
            $bookmarks=Studyset_status::where('user_id',  $request->userid)
            ->where('status',  'pending')->get();
            $handymans=array();
            foreach($bookmarks as $book){
                $primary = StudySet::where('status', 1)->where('id', $book->studyset_id)->first();
                $primary->pending_type= $book->type;
                array_push($handymans,$primary);
                // \Log::info($book->studyset_id);
            }
            foreach($handymans as $sec){
                $username= Users::where('id',$sec->posted_by )->first();               
                $count=Sets::where('studyset_id', $sec->id)->count();
                $setscount=Studyset_status::where('studyset_id', $sec->id)->where('status','completed')->count();              
                $sec->completed_sets= $setscount;
                $imgcount=Sets::where('image','!=', NULL)->where('studyset_id', $sec->id)->count();
                $sec->posted_by=$username->fullname;
                if($username->profile_img){
                $path = url('images/user/' . $username->profile_img);                
                $sec->profile_img = $path;
                }
                $sec->count= $count;
                $sec->imgcount=$imgcount;
             
                
                $sets = Sets::where('studyset_id',  $sec->id)->get();
                $studyset = StudySet::where('id',  $sec->id)->first();
                $quiz = Question::where('studyset_id', $sec->id)->get();
                $practice = Pratice_Question::where('studyset_id',  $sec->id)->get();
                $match = MatchMaking::where('studyset_id',  $sec->id)->get();
                $sec->sets=$sets ;
                $sec->quiz=$quiz ;
                $sec->practice=  $practice;
                $sec->match=$match;
            }
        }
        if($request->type=='completed'){
            $bookmarks=Studyset_status::where('user_id',  $request->userid)
            ->where('status',  'completed')->get('studyset_id');
            $handymans=array();
            foreach($bookmarks as $book){
                $primary = StudySet::where('status', 1)->where('id', $book->studyset_id)->first();
                array_push($handymans,$primary);
                // \Log::info($book->studyset_id);
            }
            foreach($handymans as $sec){
                $username= Users::where('id',$sec->posted_by )->first();               
                $count=Sets::where('studyset_id', $sec->id)->count();
                $imgcount=Sets::where('image','!=', NULL)->where('studyset_id', $sec->id)->count();
                $sec->posted_by=$username->fullname;
                $setscount=Studyset_status::where('studyset_id', $sec->id)->where('status','completed')->count();              
                $sec->completed_sets= $setscount;
                if($username->profile_img){
                $path = url('images/user/' . $username->profile_img);                
                $sec->profile_img = $path;
                }
                $sec->count= $count;
                $sec->imgcount=$imgcount;
            }
        }

            if ($handymans) {
               
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = $handymans;             
                
                return $result;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.record_not_found');
                $result['result'] = [];            
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }

    }
    public function getMysets(Request $request)
    {  $perPage=10;
        $today = Carbon::now()->toDateString();
        $yesterday = Carbon::yesterday()->toDateString(); 
        $endDate = Carbon::now()->toDateString(); // Get the current date
        $startDate = Carbon::now()->subWeek()->toDateString(); 
        $endMonthDate = Carbon::now()->startOfMonth()->subDay()->toDateString(); // Get the last day of the previous month
        $startMonthDate = Carbon::now()->startOfMonth()->subMonth()->toDateString();
        try {

            if($request->isFilter){
                \Log::info('inside filter');
                $filter=$request->filter;
                switch ($filter) {
                    case 'AtoZ':
                        $primary = StudySet::where('posted_by', $request->userid)->orderBy('name', 'asc')->paginate($perPage);
                        break;
                    case 'ZtoA':
                        $primary = StudySet::where('posted_by', $request->userid)->orderBy('name', 'desc')->paginate($perPage);
                        break;
                    case 'today':
                        $primary = StudySet::where('posted_by', $request->userid)->whereDate('created_at', $today)->paginate($perPage);
                        break;
                    case 'yesterday':
                        $primary = StudySet::where('posted_by', $request->userid)->whereDate('created_at', $yesterday)->paginate($perPage);
                        break;
                    case 'HtoL':
                        $primary = StudySet::where('posted_by', $request->userid)->orderBy('reward_points', 'desc')->paginate($perPage);
                        break;
                    case 'LtoH':
                        $primary = StudySet::where('posted_by', $request->userid)->orderBy('reward_points', 'asc')->paginate($perPage);
                        break;

                    case 'lastweek':
                        $primary = StudySet::where('posted_by', $request->userid)->whereBetween('created_at', [$startDate, $endDate])->paginate($perPage);
                        break;
                        
                    case 'lastmonth':
                        $primary = StudySet::where('posted_by', $request->userid)->whereBetween('created_at', [$startMonthDate, $endMonthDate])->paginate($perPage);
                        break;
                    case 'custom':
                        $primary = StudySet::where('posted_by', $request->userid)->whereDate('created_at', $request->custom)->paginate($perPage);
                        break;
                    default:
                    $primary = StudySet::where('posted_by', $request->userid)->where('name','like',"%{$request->filter}%")->paginate($perPage);
                        // Handle unknown filter or provide a default action
                }
          
            }else{
                $primary = StudySet::where('posted_by', $request->userid)->paginate($perPage);
            }



                 foreach($primary as $sec){
                $username= Users::where('id',$sec->posted_by )->first();               
                $count=Sets::where('studyset_id', $sec->id)->count();
                $setscount=Studyset_status::where('studyset_id', $sec->id)->where('status','completed')->count();
              
                $sec->completed_sets= $setscount;
                $imgcount=Sets::where('image','!=', NULL)->where('studyset_id', $sec->id)->count();
                $sec->posted_by=$username->fullname;
                if($username->profile_img){
                $path = url('images/user/' . $username->profile_img);                
                $sec->profile_img = $path;
                $sec->count= $count;
                $sec->imgcount=$imgcount;
                if($sec->cover_image!=null){ 
                    $sec->cover_image= url('images/studyset/' . $sec->cover_image);  
                }
                if($sec->main_image!=null){ 
                $sec->main_image= url('images/studyset/' . $sec->main_image);  
                }
                if( $sec->icon_image!=null){
                $sec->icon_image= url('images/studyset/' . $sec->icon_image);  
                }  
                }
                $sec->count= $count;
                $sec->imgcount=$imgcount;
            }
            if ($primary) {
               
                $result['status'] = 200;
                $result['message'] = __('api_msg.get_record_successfully');
                $result['result'] = $primary->items();       
                $result['total_pages'] = $primary->lastPage();     
                          
                
                return $result;
            } else {
                $msg['status'] = 400;
                $msg['message'] = __('api_msg.record_not_found');
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function getCategoryByLevelMaster(Request $request)
    {   
        try {
            $validator = Validator::make($request->all(), [
                'question_level_master_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $question_level_master_id = $request->question_level_master_id;
                
                $data = Pratice_Question::select('category_id')
                    ->where('question_level_master_id',$question_level_master_id)
                    ->groupBy('category_id')
                    ->get();
                if(count($data)){
                    foreach ($data as $key => $value) {
                        if($value->category->image){
                            $path = url('images/category/' . $value->category->image);
                            $value->category->image = $path;          
                        } else {
                            $value->category->image = "";          
                        }
                        $category[] = $value->category;
                    }
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.get_record_successfully');
                    $msg['result'] = $category;
                } else {
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.get_record_successfully');
                    $msg['result'] = [];
                }
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    
    public function getLavelByCategoryId(Request $request)
    {   
        try {
            $validator = Validator::make($request->all(), [
                'category_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $level = Level::orderBy('level_order','asc')->get();
                $category = category::get();

                if (count($level) && count($category)){
                    $size = sizeof($level);

                    $result['status'] = 200;
                    $result['message'] = __('api_msg.get_record_successfully');
                    foreach ($category as $key => $value) {
                        if($value->id == $request->category_id){
                            $result['result'] = $level;
                            for ($i = 0; $i < $size; $i++) {
                                $level[$i]->category_id = $value->id;
                                if($i == 0){
                                    $level[$i]->is_unlock = 1;
                                    $lock = Question_Is_unlock($request->user_id, $request->category_id, $level[$i]->id);
                                    if ($lock && $lock->correct_answers >= $lock->win_question_count ){
                                        if($i+1 < $size){
                                            $level[$i]->is_unlock = 1;
                                            $level[$i+1]->is_unlock = 1;
                                        }
                                    } else {
                                        if($i+1 < $size){
                                            $level[$i+1]->is_unlock = 0;
                                        }
                                    }
                                } else {
                                    $lock = Question_Is_unlock($request->user_id, $request->category_id, $level[$i]->id);
                                    if ($lock && $lock->correct_answers >= $lock->win_question_count ){
                                        if($i+1 < $size){
                                            $level[$i]->is_unlock = 1;
                                            $level[$i+1]->is_unlock = 1;
                                        }
                                    } else {
                                        if($i+1 < $size){
                                            $level[$i+1]->is_unlock = 0;
                                        }
                                    }
                                } 
                            }
                            break;
                        } else {
                            $result['result'] = [];
                        }
                    }
                    return $result;
                } else {
                    $result['status'] = 200;
                    $result['message'] = __('api_msg.get_record_successfully');
                    $result['result'] = [];
                    return $result;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

}
