<?php

namespace App\Http\Controllers\Api;

use Validator;
use App\Models\Level;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Models\Pratice_Question;
use App\Http\Controllers\Controller;

class Practice_Question_Controller extends Controller
{   
    public function getPracticeLavelByCategoryId(Request $request)
    {   
        try {
            $validator = Validator::make($request->all(), [
                'category_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $cat_id = Category::where('id', $request->category_id)->first();
                if ($cat_id) {
                    $data = Level::get();
                    $size = sizeof($data);
                    for ($i = 0; $i < $size; $i++) {
                        $data[$i]->category_id = $request->category_id;
                        $data[$i]->is_unlock = 0;
                    }
                    if (!$data->isEmpty()) {
                        $result['status'] = 200;
                        $result['message'] = __('api_msg.get_record_successfully');
                        $result['result'] = $data;
                        return $result;
                    } else {
                        $msg['status'] = 400;
                        $msg['message'] = __('api_msg.no_record');
                        return $msg;
                    }
                } else {
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.get_record_successfully');
                    $msg['result'] = [];
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function getPracticeQuestionByLavel(Request $request)
    {   
        try {
            $validator = Validator::make($request->all(), [
                'category_id' => 'required',
                'question_level_master_id' => 'required',
            ]);
            if($validator->fails()){
                $data['status'] = 400;
                $data['message'] =  __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $category_id = $request->category_id;
                $question_level_master_id = $request->question_level_master_id;

                $data = Pratice_Question::inRandomOrder()
                    ->where('category_id', $category_id)
                    ->where('question_level_master_id', $question_level_master_id)
                    ->limit('10')
                    ->get();
                if ($data) {
                    for ($i=0; $i < count($data) ; $i++) { 
                        if($data[$i]->image){
                            $path = url('images/pratice_question/' . $data[$i]->image);
                            $data[$i]->image = $path;
                        } else {
                            $data[$i]->image = "";
                        }
                    }
                    $question['status'] = 200;
                    $question['message'] = __('api_msg.get_record_successfully');
                    $question['result'] = $data;
                    return $question;
                } else {
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.get_record_successfully');
                    $msg['result'] = [];
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

}
