@extends('admin.layouts.master')
@section('title', __('Label.Level'))
@section('content')
  
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Label.Level')}}
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('levelAdd') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('Label.Add Level')}}</a>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-striped level-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>
              <th> {{__('Label.Name')}} </th>
              <th> {{__('Label.Level order No')}} </th>
              <th> {{__('Label.Score')}} </th>
              <th> {{__('Label.Total Question')}} </th>
              <th> {{__('Label.Next Level Question Count')}}</th>
              <th> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.level-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            }
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [ [0, 'asc'] ],
          ajax: "{{ route('levelData') }}",
          columns: [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
          {data: 'name', name:'name'},
          {data: 'level_order', name: 'level_order'},
          {data: 'score', name: 'score'},
          {data: 'total_question', name: 'total_question'}, 
          {data: 'win_question_count', name: 'win_question_count'},
          {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
@endpush