@extends('admin.layouts.master')
@section('title', __('Edit Page'))
@section('content')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
  		<!-- Start: Body-Content -->
  		<div class="body-content">
  			<!-- mobile title -->
  			<h1 class="page-title-sm">@yield('title')</h1>

  			<div class="border-bottom row mb-3">
  				<div class="col-sm-10">
  					<ol class="breadcrumb">
  						<li class="breadcrumb-item">
  							<a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
  						</li>
  						<li class="breadcrumb-item">
  							<a href="{{ route('pages') }}">{{__('Pages')}}</a>
  						</li>
  						<li class="breadcrumb-item active" aria-current="page">
  							{{__('Edit Page')}}
  						</li>
  					</ol>
  				</div>
  				<div class="col-sm-2 d-flex align-items-center">
  					<a href="{{ route('pages') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Pages List')}}</a>
  				</div>
  			</div>

  			<div class="card custom-border-card mt-3">
  				<form enctype="multipart/form-data" id="save_edit_user">
  					@csrf
  					<div class="form-row">
					  <div class="col-md-4 mb-3">
  							<div class="form-group">
  								<label for="Inputtext1">Page {{$result->id}}</label>
  								<input name="page" type="text" class="form-control " id="Inputtext1" value="{{$result->page}}" readonly>
  							</div>
  						</div>	
					</div>
					  <div class="form-row">
						<div class="col-md-12 mb-3">
  							<div class="form-group">
  								<label for="Inputtext2">Content </label>
  								<textarea  name="content"  class="form-control summernote" id="Inputtext2" >{{$result->content}}</textarea>
  							</div>
  						</div>
					</div>
  				
  					<div class="border-top pt-3">
  						<input type="hidden" value="{{$result->id}}" name="id">
  						<button type="button" class="btn btn-default mw-120" onclick="save_edit_user()">{{__('Label.UPDATE')}}</button>
  						<a href="{{route('pages')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
  					</div>
  				</form>
  			</div>
  		</div>
  		<!-- End: Body-Content -->
  	</div>
  	<!-- End: Right Contenct -->
@endsection

@push('scripts')

	<script type="text/javascript">

		function save_edit_user(){
			$("#dvloader").show();
			var formData = new FormData($("#save_edit_user")[0]);

			
			$.ajax({
				type:'POST',
				url:'{{ route("pagesUpdate") }}',
				data:formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'save_edit_user', '{{ route("pages") }}');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					$("#dvloader").hide();
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}

		$(document).ready(function (e) {

			$('#profile_img').change(function(){
				let reader = new FileReader();
				reader.onload = (e) => { 
					$('#preview-image-before-upload').attr('src', e.target.result); 
				}
				reader.readAsDataURL(this.files[0]); 

			});

		});
	</script>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('.summernote').summernote({
                height: 350,
            });
        });
  
    </script>
@endpush