@extends('admin.layouts.master')
@section('title', __('Pages List'))
@section('content')
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1> 

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Pages List')}}
            </li>
          </ol>
        </div>
        <!-- <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('pagesAdd') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('Add Page')}}</a>
        </div> -->
      </div>

      <div class="table-responsive">
        <table class="table table-striped user-table text-center table-bordered example">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>
             <th>Page name</th>
              <th> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->

@endsection

@push('scripts')
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.user-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            },
            // multi Language Label Of Table
            // "sLengthMenu": "{{__('Label.Show')}}_MENU_{{__('Label.Entries')}} ",
            // "sProcessing": "{{__('Label.Processing')}}",
            // "sZeroRecords": "{{__('Label.No_data_available_in_table')}}",
            // "sSearch": "{{__('Label.Serach')}}",              
            // "sInfoEmpty": "{{__('Label.Showing_0_to_0_of_0_entries')}}",
            // "sInfo": "{{__('Label.Watch')}} _START_ {{__('Label.To')}} _END_ {{__('Label.Total')}} _TOTAL_ ",
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [0, 'desc'],
          ajax: "{{ route('pagesData') }}",
          columns: [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
          {data: 'page', name: 'page'}, 
          {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>

  <script>
    function archiveFunction(id) {

      event.preventDefault(); // prevent form submit
      swal({
        title: "Are you sure?",
        text: "You will not be able to recover this Users!.",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#4e45b8",
        confirmButtonText: "YES, ARCHIVE IT!",
        cancelButtonText: "NO, CANCEL PLX!",
        closeOnConfirm: false,
        closeOnCancel: false
      },
      function(isConfirm){
        if (isConfirm) {
          let abc = "{{ URL('admin/user/delete') }}"+"/"+id;
          window.location.href = abc
        } else {
          swal("Cancelled", "Your imaginary file is safe :)", "error");
        }
      });
    }
  </script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>
@endpush
