

<?php $__env->startSection('title',  __('Flash Card')); ?>
<?php $__env->startSection('content'); ?>
 
    <!-- Start:  Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>
      <h5>Study Set: <?php echo e($name); ?></h5>
      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"> <?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              Flash Card
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center" style="margin-top:-14px">
          <a href="<?php echo e(route('setsAdd', ['id'=>$id])); ?>" class="btn btn-default mw-120">add Flashcard</a>
        </div>
      </div>
      
      <div class="table-responsive">
        <table class="table table-striped category-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> <?php echo e(__('Label.Id')); ?> </th>
              <th> Ques</th> 
              <th> Des</th>
              <th> <?php echo e(__('Label.Action')); ?> </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.category-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' >",
              next: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' style='transform: rotate(180deg)'>"
            }
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [ [0, 'asc'] ],
          ajax: "<?php echo e(route('setsData',['id'=>$id])); ?>",
          columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            // { data: 'image', name: 'image', 
            //   "render": function (data, type, full, meta) {
            //     if(data){
            //       return "<img src='<?php echo e(url('images/category/')); ?>/"+ data + "' height=50 width=50/>";
            //     } else {
            //       return "<img src='<?php echo e(url('assets/imgs/1.png')); ?>' height=50 />";
            //     }
            //   },
            // },
            
            {data: 'question', name:'question'},
            {data: 'description', name:'description'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
  
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/sets/index.blade.php ENDPATH**/ ?>