
<?php $__env->startSection('title', __('Label.Import Questions')); ?>
<?php $__env->startSection('content'); ?>
  
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-12">
          <ol class="breadcrumb">
           <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              <?php echo e(__('Label.Import Questions')); ?>

            </li>
          </ol>
        </div>
      </div>

      <div class="card custom-border-card mt-3">
        <form enctype="multipart/form-data" id="save_question_import">
          <?php echo csrf_field(); ?>

          <div class="form-row">
            <div class="col-md-1"></div>
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <label for="import_file"><?php echo e(__('Label.CSV QUESTIONS FILE')); ?></label>
                <input type="file" class="form-control" id="import_file" name="import_file">
              </div>
            </div>
          </div>
          <div class="border-top mt-2 pt-3">
            <button type="button" class="btn btn-default mw-120 ml-5"onclick="save_question_import()"><?php echo e(__('Label.UPLOAD CSV FILE')); ?></button>
            <a class="btn btn-warning ml-5" href="<?php echo e(route('question_export')); ?>"><?php echo e(__('Label.DOWNLOAD SAMPLE FILE HERE')); ?></a>
          </div>
        </form>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
  <script type="text/javascript">

    function save_question_import(){
      $("#dvloader").show();
      var formData = new FormData($("#save_question_import")[0]);
      $.ajax({
        type:'POST',
        url:'<?php echo e(route("question_import")); ?>',
        data:formData,
        cache:false,
        contentType: false,
        processData: false,
        success:function(resp){
          $("#dvloader").hide();
          get_responce_message(resp, 'save_question_import', '<?php echo e(route("questionimport")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $("#dvloader").hide();
          toastr.error(errorThrown.msg,'failed');         
        }
      });
    }
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/question_import/index.blade.php ENDPATH**/ ?>