
<?php $__env->startSection('title', __('Label.Edit Category')); ?>
<?php $__env->startSection('content'); ?>

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item">
              <a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item">
              <a href="<?php echo e(route('studyset')); ?>"><?php echo e(__('Label.studyset')); ?></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
            Edit <?php echo e(__('Label.studyset')); ?>

            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="<?php echo e(route('studyset')); ?>" class="btn btn-default mw-120" style="margin-top:-14px"><?php echo e(__('Label.Studyset')); ?></a>
        </div>
      </div>

      <div class="card custom-border-card mt-3">
      	<form enctype="multipart/form-data" id="save_edit_category">
      		<?php echo csrf_field(); ?>
      		<div class="form-row">
      			<div class="col-md-12 mb-3">
      				<div class="form-group">
      					<label for="name"><?php echo e(__('Label.NAME')); ?></label>
      					<input name="name" type="text" class="form-control" id="name" value="<?php echo e($result->name); ?>">
      				</div>
      			</div>
      		</div>
          <div class="form-row">
    				<div class="col-md-6 mb-3">
    					<div class="form-group">
    						<label for="category_id">Category</label>
    						<select class="form-control" id="category_id" name="category_id">
    							<option value="">Select Category</option>
    							<?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    							<option value="<?php echo e($value->id); ?>" <?php echo e($result->category_id == $value->id  ? 'selected' : ''); ?>> 
    								<?php echo e($value->name); ?> 
    							</option>
    							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  
    						</select>
    					</div>
    				</div>    			
    			</div>
          <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Status</label>
                        <select class="form-control status" id="status" name="status">
    							<option value="">Select</option>
    							
    							<option value="1"  <?php echo e($result->status == 1 ? 'selected' : ''); ?> > 
    								Active 
    							</option>
                 <option value="0"  <?php echo e($result->status == 0 ? 'selected' : ''); ?>> Inactive</option>
                
    							
    						</select>
                    </div>
                </div>
            </div>
			<div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">is Featured</label>
                        <select class="form-control status" id="featured" name="featured">
    							<option value="">Select</option>
    							
    							<option value="1"  <?php echo e($result->featured == 1 ? 'selected' : ''); ?> > 
    								Yes 
    							</option>
                 <option value="0"  <?php echo e($result->featured == 0 ? 'selected' : ''); ?>> No</option>
                
    							
    						</select>
                    </div>
                </div>
            </div>
                <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Reward Type</label>
                        <select class="form-control reward_type" id="reward_type" name="reward_type">
    							<option value="">Select</option>
    							
    							<option value="1"  <?php echo e($result->reward_type == 1 ? 'selected' : ''); ?> > 
    								Primary 
    							</option>
                 <option value="2"  <?php echo e($result->reward_type == 2 ? 'selected' : ''); ?>> Secondary</option>
                  <option value="3"  <?php echo e($result->reward_type == 3 ? 'selected' : ''); ?>> None</option>
    							
    						</select>
                    </div>
                </div>
            </div>
            <div class="form-row option_class ">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Reward points</label>
                        <input name="reward_points" type="text" class="form-control" id="reward_points"
                            placeholder="Enter Reward points" value="<?php echo e($result->reward_points); ?>">
                    </div>
                </div>
            </div>
            <div class="form-row option_class">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Max Reward Per User</label>
                        <input name="max_userpoints" type="text" class="form-control" id="max_userpoints"
                            placeholder="Reward for user" value="<?php echo e($result->max_userpoints); ?>">
                    </div>
                </div>
            </div>
            <div class="form-row">
    				<div class="col-md-6"> 
    					<div class="form-group"> 
    						<label for="image">Cover Image</label> 
    						<input type="file" class="form-control" id="cover_image" name="cover_image" > 
    						<label class="mt-1"><?php echo e(__('Label.Note_Image')); ?></label>
    					</div>
    				</div>
    				<div class="col-md-6"> 
    					<div class="form-group">
    						<div class="custom-file ml-5"> 
                <?php 
										if($result->cover_image){
											$app = URL::asset('/images/studyset').'/'.$result->cover_image;
										} else {
											$app = URL::asset('/assets/imgs/1.png'); 
										}
									?>
    							<img  src="<?php echo e($app); ?>" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
    						</div>
    					</div>
    				</div>
    			</div>
                <div class="form-row">
    				<div class="col-md-6"> 
    					<div class="form-group"> 
    						<label for="image"> Image</label> 
    						<input type="file" class="form-control" id="main_image" name="main_image" > 
    						<label class="mt-1"><?php echo e(__('Label.Note_Image')); ?></label>
    					</div>
    				</div>
    				<div class="col-md-6"> 
    					<div class="form-group">
    						<div class="custom-file ml-5"> 
                <?php 
										if($result->main_image){
											$app = URL::asset('/images/studyset').'/'.$result->main_image;
										} else {
											$app = URL::asset('/assets/imgs/1.png'); 
										}
									?>
    							<img  src="<?php echo e($app); ?>" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
    						</div>
    					</div>
    				</div>
    			</div>
                <div class="form-row">
    				<div class="col-md-6"> 
    					<div class="form-group"> 
    						<label for="image">Icon Image</label> 
    						<input type="file" class="form-control" id="icon_image" name="icon_image" > 
    						<label class="mt-1"><?php echo e(__('Label.Note_Image')); ?></label>
    					</div>
    				</div>
    				<div class="col-md-6"> 
    					<div class="form-group"> 
    						<div class="custom-file ml-5"> 
    						<?php 
										if($result->icon_image){
											$app = URL::asset('/images/studyset').'/'.$result->icon_image;
										} else {
											$app = URL::asset('/assets/imgs/1.png'); 
										}
									?>
    							<img  src="<?php echo e($app); ?>" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
    						</div>
    					</div>
    				</div>
    			</div>

      		<div class="border-top mt-2 pt-3">
      			<input type="hidden" value="<?php echo e($result->id); ?>" name="id">
      			<button type="button" class="btn btn-default mw-120" onclick="save_edit_category()"><?php echo e(__('Label.UPDATE')); ?></button>
            <a href="<?php echo e(route('category')); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('Label.CANCEL')); ?></a>
      		</div>
      	</form>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
 <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
  <script type="text/javascript">
    function save_edit_category(){
      $("#dvloader").show();
      var formData = new FormData($("#save_edit_category")[0]);
      $.ajax({
        type:'POST',
        url:'<?php echo e(route("studysetUpdate")); ?>',
        data:formData,
        cache:false,
        contentType: false,
        processData: false,
        success:function(resp){
          $("#dvloader").hide();
          get_responce_message(resp, 'save_edit_category', '<?php echo e(route("studyset")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $("#dvloader").hide();
          toastr.error(errorThrown.msg,'failed');         
        }
      });
    }
    $(document).ready(function() {
			var myVal = <?php echo e($result->reward_type); ?>

			if (myVal == 3) {
				$('.option_class').hide();
			
			} else {
				$('.option_class').show();
			
			}
		});
    $('.reward_type').on('change', function() {
  		if (this.value == 3) {
				$('.option_class').hide();
			} else {
				$('.option_class').show();
			}
});
  </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/studyset/edit.blade.php ENDPATH**/ ?>