
<?php $__env->startSection('title', __('Label.Dashboard')); ?>
<?php $__env->startSection('content'); ?>

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>

      <div class="row counter-row">
        <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
          <div class="db-color-card user-card">
            <img src="<?php echo e(asset('assets/imgs/user-brown.png')); ?>" alt="" class="card-icon" />
            <div class="dropdown dropright">
              <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <img src="<?php echo e(asset('assets/imgs/dot.png')); ?>" class="dot-icon" />
              </a>
              <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                <a class="dropdown-item" href="<?php echo e(route('user')); ?>" style="color: #A98471;"><?php echo e(__('Label.View All')); ?></a>
              </div>
            </div>
            <h2 class="counter">
              <?php echo e($result['user']); ?>

              <span><?php echo e(__('Label.Users')); ?></span>
            </h2>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
          <div class="db-color-card cate-card">
            <img src="<?php echo e(asset('assets/imgs/categories-purple.png')); ?>" alt="" class="card-icon" />
            <div class="dropdown dropright">
              <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <img src="<?php echo e(asset('assets/imgs/dot.png')); ?>" class="dot-icon" />
              </a>
              <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                <a class="dropdown-item" href="<?php echo e(route('category')); ?>" style="color: #736AA6"><?php echo e(__('Label.View All')); ?></a>
              </div>
            </div>
            <h2 class="counter">
              <?php echo e($result['category']); ?>

              <span><?php echo e(__('Label.Category')); ?></span>
            </h2>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
          <div class="db-color-card artist-card">
            <img src="<?php echo e(asset('assets/imgs/LEVEL.png')); ?>" alt="" class="card-icon" style="color:#6db3c6;" />
            <div class="dropdown dropright">
              <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <img src="<?php echo e(asset('assets/imgs/dot.png')); ?>" class="dot-icon" />
              </a>
              <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                <a class="dropdown-item" href="<?php echo e(route('level')); ?>" style="color: #6DB3C6"><?php echo e(__('Label.View All')); ?></a>
              </div>
            </div>
            <h2 class="counter">
              <?php echo e($result['level']); ?>

              <span><?php echo e(__('Label.Level')); ?></span>
            </h2>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
          <div class="db-color-card package-card">
            <img src="<?php echo e(asset('assets/imgs/QUESRTION.png')); ?>" alt="" class="card-icon" />
            <div class="dropdown dropright">
              <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <img src="<?php echo e(asset('assets/imgs/dot.png')); ?>" class="dot-icon" />
              </a>
              <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                <a class="dropdown-item" href="<?php echo e(route('question')); ?>" style="color: #C0698B"><?php echo e(__('Label.View All')); ?></a>
              </div>
            </div>
            <h2 class="counter">
              <?php echo e($result['question']); ?>

              <span><?php echo e(__('Label.Question')); ?></span>
            </h2>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-12 col-xl-8">
          <div class="box-title">
            <h2 class="title"><?php echo e(__('Label.Recent Added Users')); ?></h2>
            <a href="<?php echo e(route('user')); ?>" class="btn btn-link"><?php echo e(__('Label.View All')); ?></a>
          </div>
          <div class="table-responsive">
            <table class="table table-striped">
              <thead>
                <tr>
                  <th>
                    <?php echo e(__('Label.Full Name')); ?>

                  </th>
                  <th>
                    <?php echo e(__('Label.Email')); ?>

                  </th>
                  <th>
                    <?php echo e(__('Label.Number')); ?>

                  </th>
                  <th>
                    <?php echo e(__('Label.Type')); ?>

                  </th>
                  <th>
                    <?php echo e(__('Label.Created Date')); ?>

                  </th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $user_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td>
                    <span class="avatar-control">
                      <?php 
                        if($value->profile_img){
                          $app = URL::asset('/images/user').'/'. $value->profile_img; 
                        } else {
                          $app = URL::asset('/assets/imgs/1.png'); 
                        }
                      ?>
                      <img src="<?php echo e($app); ?>" class="avatar-img">
                      <?php if($value->fullname): ?>
                        <?php echo e($value->fullname); ?>

                      <?php else: ?>
                        -
                      <?php endif; ?>
                    </span>
                  </td>
                  <td>
                    <?php if($value->email): ?>
                      <?php echo e($value->email); ?>

                    <?php else: ?>
                      -
                    <?php endif; ?>
                  </td>
                  <td>
                    <?php if($value->mobile_number): ?>
                      <?php echo e($value->mobile_number); ?>

                    <?php else: ?>
                      -
                    <?php endif; ?>
                  </td>
                  <td>
                    <?php if($value->type == 1): ?>
                    <?php echo e(__('Label.Normal')); ?>

                    <?php elseif($value->type == 2): ?>
                    <?php echo e(__('Label.Social')); ?>

                    <?php else: ?>
                    <?php echo e(__('Label.OTP')); ?>

                    <?php endif; ?>
                  </td>
                  <td><?php echo e($value->c_date); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
          <div class="box-title">
            <h2 class="title"><?php echo e(__('Label.Subscriptions')); ?></h2>
            <a href="<?php echo e(route('subscription')); ?>" class="btn btn-link"><?php echo e(__('Label.View All')); ?></a>
          </div>
          <div class="row">
            <div class="col-12 col-sm-4 mt-1">
              <canvas id="myChart" width="70%" height="100px"></canvas>
            </div>
            <div class="col-12 col-sm-8 mt-2">
              <h2 class="title mt-1" style="font-size: 18px; font-weight: 600;"><?php echo e(__('Label.Recent Transaction')); ?></h2>
              <div class="summary-table-card">
                <?php $__currentLoopData = $transaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="border-card">
                  <div class="row">
                    <div class="col-12 col-md">
                      <span class="avatar-control">
                        <?php 
                          if($value->users->profile_img){
                            $app = URL::asset('/images/user').'/'. $value->users->profile_img; 
                          } else {
                            $app = URL::asset('/assets/imgs/1.png'); 
                          }
                        ?>
                        <img src="<?php echo e($app); ?>" class="avatar-img">
                        <?php echo e(string_cut($value->users->fullname ?? '', 9)); ?>

                      </span>
                    </div>
                    <div class="col">
                      <?php echo e($value->transaction_date ?? ''); ?>

                    </div>
                    <div class="col">
                      <p class="d-flex m-0 align-items-center">
                        <span class="dot bg-green"></span>
                        <?php echo e($value->plan_subscription->name ?? ''); ?>

                      </p>
                    </div>
                    <div class="col">
                      <span class="price"><?php echo e($value->plan_subscription->currency_type ?? ''); ?><?php echo e($value->plan_subscription->price ?? ''); ?></span>
                    </div>
                  </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
          </div>
          <div class="box-title">
            <h2 class="title"><?php echo e(__('Label.Latest Contest')); ?></h2>
            <a href="<?php echo e(route('contest')); ?>" class="btn btn-link"><?php echo e(__('Label.View All')); ?></a>
          </div>
          <div class="row artist-row">
            <?php $__currentLoopData = $latest_contest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-6 col-md-3">
              <div class="artist-grid-card">
                <span class="avatar-control">
                  <?php 
                    if($value->image){
                      $app = URL::asset('/images/contest').'/'. $value->image; 
                    } else {
                      $app = URL::asset('/assets/imgs/1.png'); 
                    }
                  ?>       
                 <img src="<?php echo e($app); ?>" class="avatar-img mr-3">
                  <?php echo e(__('Label.Enrty')); ?>

                  <button class="btn btn-success btn-sm ml-md-1" >&#8377; <?php echo e($value->price); ?></button>
                </span>
                
                <h3 class="name" style="display: inline-block; text-overflow:ellipsis; white-space:nowrap; overflow:hidden; width:100%;"><?php echo e($value->name); ?></h3>
                
                <p style="font-size:18"><?php echo e(__('Label.Total User')); ?> : <b><?php echo e($value->no_of_user); ?></b><br><?php echo e(__('Label.Total Prize')); ?> : <b><?php echo e($value->total_prize); ?></b><br><?php echo e(__('Label.Winning Rank')); ?> : <b><?php echo e($value->no_of_rank); ?></b></p>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
        <div class="col-12 col-xl-4">
          <div class="video-box">
            <div class="box-title mt-0">
              <h2 class="title"><?php echo e(__('Label.UpComming Contest')); ?></h2>
              <a href="<?php echo e(route('contest')); ?>" class="btn btn-link"><?php echo e(__('Label.View All')); ?></a>
            </div>
            <div class="p-3 bg-white mt-4">
              <?php $__currentLoopData = $upcomming_contest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php 
                  if($value->image){
                    $app = URL::asset('/images/contest').'/'. $value->image; 
                  } else {
                    $app = URL::asset('/assets/imgs/1.png'); 
                  }
                ?>
                <img src="<?php echo e($app); ?>" class="img-fluid mx-auto d-block" width="90%">
                <div class="box-title box-border-0 d-flex">
                  <h5 class="f600" style="display: inline-block; text-overflow:ellipsis; white-space:nowrap; overflow:hidden; width:75%;"><?php echo e($value->name); ?></h5>
                  <button class="btn btn-success btn-sm ">&#8377; <?php echo e($value->price); ?></button>
                </div>
                <p id="demo" style="color:#fb424a; font-size:18px" class="font-weight-bold mt-2 mb-0 text-center"></p>
                <?php break; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="box-title" style="margin-top:5px">
            </div>
            <div class="row">              
              <?php $__currentLoopData = $upcomming_contest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php if($key > 0): ?>
              <div class="col-sm-6 col-xl-12">
                <div class="media suggested-video">
                  <?php 
                    if($value->image){
                      $app = URL::asset('/images/contest').'/'. $value->image; 
                    } else {
                      $app = URL::asset('/assets/imgs/1.png'); 
                    }
                  ?>
                  <img src="<?php echo e($app); ?>" class="mr-3 poster-img">
                  <div class="media-body">
                    <h5 class="mt-0 video-title"><?php echo e($value->name); ?></h5>
                    <div class="details">
                      <p class="font-weight-bold" style="color:#fb424a;"><?php echo e($value->start_date); ?><br> <?php echo e(__('Label.To')); ?> <br> <?php echo e($value->end_date); ?> <br></p>
                    </div>
                  </div>
                  <button class="btn btn-success btn-sm">&#8377; <?php echo e($value->price); ?></button><br>
                </div>
              </div>
              <?php endif; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
  <script>
    $(function(){
      //get the pie chart canvas
      var cData = JSON.parse(`<?php echo $package; ?>`);
      var ctx = $("#myChart");

      //pie chart data
      var data = {
        labels: cData.label,
        datasets: [
        {
          data: cData.price,
          backgroundColor: [
          "#DEB887",
          "#A9A9A9",
          "#1D7A46",
          "#F4A460",
          "#DC143C",
          "#2E8B57",
          "#CDA776",
          "#003F5C",
          "#BC5090",
          "#FF6361",
          "#FFF1C9",
          "#DEB887",
          "#A9A9A9",
          "#1D7A46",
          "#F4A460",
          "#DC143C",
          "#2E8B57",
          "#CDA776",
          "#003F5C",
          "#BC5090",
          "#FF6361",
          "#FFF1C9",
          ],
        }
        ]
      };

      //options
      var options = {
        responsive: true,
        title: {
          display: true,
          position: "top",
          text: "<?php echo e(__('Label.Package Name and Price (INR)')); ?>",
          fontSize: 18,
          fontColor: "#000"
        },
        legend: {
          title: "text",
          display: true,
          position: 'bottom',
          labels: {
            fontSize: 14,
            fontColor: "#000",
            fontwight: "600"
          }
        }
      };

      //create Pie Chart class object
      var chart1 = new Chart(ctx, {
        type: "doughnut",
        data: data,
        options: options
      });
    });
  </script>
  <script>

    <?php $__currentLoopData = $upcomming_contest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

      var countDownDate = new Date("<?php echo e($value->start_date); ?>").getTime();

      var x = setInterval(function() {

        var now = new Date().getTime();
        var distance = countDownDate - now;

        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

        document.getElementById("demo").innerHTML = days + "d " + hours + "h " + minutes + "m " + seconds + "s ";
        if (distance < 0) {
          clearInterval(x);
          document.getElementById("demo").innerHTML = "LIVE";
        }
      }, 1000);
    <?php break; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\envato\app\dtquiz_backend\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>