
<?php $__env->startSection('title', __('Label.Edit Pratice Question')); ?>
<?php $__env->startSection('content'); ?>

    	<!-- Start: Body-Content -->
    	<div class="body-content">
    		<!-- mobile title -->
    		<h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>
			<h5>Study Set: <?php echo e($name); ?></h5>
    		<div class="border-bottom row mb-3">
    			<div class="col-sm-10">
    				<ol class="breadcrumb">
    			  		<li class="breadcrumb-item">
    						<a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
    					</li>
    					<li class="breadcrumb-item">
    						<a href="<?php echo e(route('praticequestion',['id'=>$setId])); ?>"><?php echo e(__('Label.Pratice Question')); ?></a>
    					</li>
    					<li class="breadcrumb-item active" aria-current="page">
    						<?php echo e(__('Label.Edit Pratice Question')); ?>

    					</li>
    				</ol>
    			</div>
    			<div class="col-sm-2 d-flex align-items-center">
    				<a href="<?php echo e(route('praticequestion',['id'=>$setId])); ?>" class="btn btn-default mw-120" style="margin-top:-14px"><?php echo e(__('Label.Pratice Question')); ?></a>
    			</div>
    		</div>

    		<div class="card custom-border-card mt-3">
    			<form enctype="multipart/form-data" id="save_edit_pratice_question">
    				<?php echo csrf_field(); ?>

    			
    				<div class="form-row">
    					<div class="col-md-12 mb-3">
    						<div class="form-group">
    							<label for="question"><?php echo e(__('Label.QUESTION')); ?></label>
    							<textarea class="form-control" id="question" rows="4" name="question"><?php echo e($result->question); ?></textarea>
    						</div>
    					</div>
    				</div>
					<div class="form-row option_class1">
    				<div class="col-md-12 mb-3">
    					<div class="form-group">
    						<label for="term">Term</label>
    						<input class="form-control"   id="term" value="<?php echo e($result->term); ?>"   name="term"/>
    					</div>
    				</div>
    				</div>
    				<div class="form-row">
    					<div class="col-md-6 mb-3">
    						<div class="form-group">
    							<label for="image"><?php echo e(__('Label.IMAGE')); ?></label>
    							<input type="file" class="form-control" id="image" name="image" value="<?php echo e($result->image); ?>">
    							<label class="mt-1"><?php echo e(__('Label.Note_Image')); ?></label>
    						</div>
    					</div>
    					<div class="col-md-6 mb-3">
    						<div class="form-group">
    							<div class="custom-file ml-5">
    								<?php 
										if($result->image){
											$app = URL::asset('/images/pratice_question').'/'.$result->image; 
										} else {
											$app = URL::asset('/assets/imgs/1.png');
										}
									?>
    								<img  src="<?php echo e($app); ?>" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
    								<input type="hidden" name="old_image" value="<?php echo e($result->image); ?>">
    							</div>
    						</div>
    					</div>
    				</div>
    				<div class="form-row">
    					<div class="col-md-6 mb-3">
    						<div class="form-group">
    							<label for="question_type"><?php echo e(__('Label.QUESTION TYPE')); ?></label>
    							<span class="border col-md-3 p-2 m-4">
    								<input type="radio" value="1" id="question_type" name="question_type" class="question_type" <?php echo e(($result->question_type) == '1' ? 'checked' : ''); ?>>
									<label for="question_type"><?php echo e(__('Label.Options')); ?></label>
    							</span>
    							<span class="border col-md-3 p-2">
    								<input type="radio" value="2" name="question_type" class="question_type" <?php echo e(($result->question_type) == '2' ? 'checked' : ''); ?>>  
									<label for="question_type"><?php echo e(__('Label.True/False')); ?></label>
    							</span>
    						</div>
    					</div>
    				</div>
    				<div class="form-group row">
    					<div class="col-sm-1"></div>
    					<div class="col-sm-5">
    						<label class="form-check-input"><?php echo e(__('Label.A')); ?></label> <input type="text" value="<?php echo e($result->option_a); ?>" name="option_a" class="form-control" id="option_a">
    					</div>
    					<div class="col-sm-5">
    						<label class="form-check-input"><?php echo e(__('Label.B')); ?></label> <input type="text" value="<?php echo e($result->option_b); ?>" name="option_b" class="form-control" id="option_b">
    					</div>
    				</div>
    				<div class="form-group row option_class">
    					<div class="col-sm-1"></div>
    					<div class="col-sm-5">
    						<label class="form-check-input"><?php echo e(__('Label.C')); ?></label> <input type="text" value="<?php echo e($result->option_c); ?>" name="option_c" class="form-control" id="option_c">
    					</div>
    					<div class="col-sm-5">
    						<label class="form-check-input"><?php echo e(__('Label.D')); ?></label> <input type="text" value="<?php echo e($result->option_d); ?>" name="option_d" class="form-control" id="option_d">
    					</div>
    				</div>
    				<div class="form-row">
    					<div class="col-md-6 mb-3">
    						<div class="form-group">
    							<label for="level_id"><?php echo e(__('Label.LEVEL')); ?></label>
    							<select class="form-control" id="level_id" name="level_id">
    								<option value=""><?php echo e(__('Label.Select Level')); ?></option>
    								<?php $__currentLoopData = $level; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    								<option value="<?php echo e($value->id); ?>" <?php echo e($result->level_id == $value->id  ? 'selected' : ''); ?>> 
    									<?php echo e($value->name); ?> 
    								</option>
    								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  
    							</select>
    						</div>
    					</div>
    					<div class="col-md-6 mb-3">
    						<div class="form-group">
    							<label for="answer"><?php echo e(__('Label.ANSWER')); ?></label>
    							<select class="form-control" id="answer" name="answer">
    								<option value=""><?php echo e(__('Label.Select Right Answer')); ?></option>
    								<option value="1" <?php echo e(($result->answer) == '1' ? 'selected' : ''); ?>> <?php echo e(__('Label.A')); ?> </option>
    								<option value="2" <?php echo e(($result->answer) == '2' ? 'selected' : ''); ?>> <?php echo e(__('Label.B')); ?> </option>
    								<option value="3" <?php echo e(($result->answer) == '3' ? 'selected' : ''); ?> class="option_class"> <?php echo e(__('Label.C')); ?> </option>
    								<option value="4" <?php echo e(($result->answer) == '4' ? 'selected' : ''); ?> class="option_class"> <?php echo e(__('Label.D')); ?> </option>
    							</select>
    						</div>
    					</div>
    				</div>
    			
    				<div class="border-top mt-2 pt-3">
    					<input type="hidden" value="<?php echo e($result->id); ?>" name="id">
    					<button type="button" class="btn btn-default mw-120" onclick="save_edit_pratice_question()"><?php echo e(__('Label.UPDATE')); ?></button>
    					<a href="<?php echo e(route('praticequestion',['id'=>$setId])); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('Label.CANCEL')); ?></a>
    				</div>
    			</form>
    		</div>
    	</div>
    	<!-- End: Body-Content -->
    </div>
    <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">

		function save_edit_pratice_question(){
			$("#dvloader").show();
			var formData = new FormData($("#save_edit_pratice_question")[0]);
			$.ajax({
				type:'POST',
				url:'<?php echo e(route("praticequestionUpdate")); ?>',
				data:formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'save_edit_pratice_question', '<?php echo e(route("praticequestion",["id"=>$setId])); ?>');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					$("#dvloader").hide();
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}
		$(document).ready(function() {
			var myVal = <?php echo e($result->question_type); ?>

			if (myVal == 2) {
				$('.option_class').hide();
				$('.option_class1').show();
			} else {
				$('.option_class').show();
				$('.option_class1').hide();
			}
		});
		$('.question_type').on('click', function() {

			var question_type = $('input[name=question_type]:checked').val()
			if (question_type == 1) {
				$('.option_class').show();
				$('.option_class1').hide();
			} else {
				$('.option_class').hide();
				$('.option_class1').show();
			}
		})
    </script>


<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/pratice_question/edit.blade.php ENDPATH**/ ?>