
<?php $__env->startSection('title', __('Label.Edit Category')); ?>
<?php $__env->startSection('content'); ?>

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>
 
      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item">
              <a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item">
              <a href="<?php echo e(route('category')); ?>"><?php echo e(__('Label.Category')); ?></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              <?php echo e(__('Label.Edit Category')); ?>

            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="<?php echo e(route('category')); ?>" class="btn btn-default mw-120" style="margin-top:-14px"><?php echo e(__('Label.Category')); ?></a>
        </div>
      </div>

      <div class="card custom-border-card mt-3">
      	<form enctype="multipart/form-data" id="save_edit_category">
      		<?php echo csrf_field(); ?>
      		<div class="form-row">
      			<div class="col-md-12 mb-3">
      				<div class="form-group">
      					<label for="name"><?php echo e(__('Label.NAME')); ?></label>
      					<input name="name" type="text" class="form-control" id="name" value="<?php echo e($result->name); ?>">
      				</div>
      			</div>
      		</div>
      		<div class="form-row">
            <div class="col-md-6"> 
              <div class="form-group"> 
                <label for="image"><?php echo e(__('Label.IMAGE')); ?></label> 
                <input type="file" class="form-control" id="image" name="image"> 
                <label class="mt-1"><?php echo e(__('Label.Note_Image')); ?></label>
              </div>
            </div>
            <div class="col-md-6"> 
              <div class="form-group">
                <div class="custom-file ml-5"> 
                  <?php 
                    if ($result->image){
                      $app = URL::asset('/images/category').'/'.$result->image;
                    } else{
                      $app = asset('assets/imgs/1.png');
                    }
                  ?>
                  <img  src="<?php echo e($app); ?>" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
      						<input type="hidden" name="old_image" value="<?php echo e($result->image); ?>">
                </div>
              </div>
            </div>
          </div>
      		<div class="border-top mt-2 pt-3">
      			<input type="hidden" value="<?php echo e($result->id); ?>" name="id">
      			<button type="button" class="btn btn-default mw-120" onclick="save_edit_category()"><?php echo e(__('Label.UPDATE')); ?></button>
            <a href="<?php echo e(route('category')); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('Label.CANCEL')); ?></a>
      		</div>
      	</form>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
 <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
  <script type="text/javascript">
    function save_edit_category(){
      $("#dvloader").show();
      var formData = new FormData($("#save_edit_category")[0]);
      $.ajax({
        type:'POST',
        url:'<?php echo e(route("categoryUpdate")); ?>',
        data:formData,
        cache:false,
        contentType: false,
        processData: false,
        success:function(resp){
          $("#dvloader").hide();
          get_responce_message(resp, 'save_edit_category', '<?php echo e(route("category")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $("#dvloader").hide();
          toastr.error(errorThrown.msg,'failed');         
        }
      });
    }
  </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/category/edit.blade.php ENDPATH**/ ?>