
<?php $__env->startSection('title', __('Label.Contest')); ?>
<?php $__env->startSection('content'); ?>

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              <?php echo e(__('Label.Contest')); ?>

            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="<?php echo e(route('contestAdd')); ?>" class="btn btn-default mw-120" style="margin-top: -14px;"><?php echo e(__('Label.Add Contest')); ?></a>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-striped contest-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> <?php echo e(__('Label.Id')); ?> </th>
              <th> <?php echo e(__('Label.Name')); ?> </th>
              <th> <?php echo e(__('Label.Start Date')); ?> </th>
              <th> <?php echo e(__('Label.End Date')); ?> </th>
              <th> <?php echo e(__('Label.Price')); ?> </th>
              <th> <?php echo e(__('Label.No of User')); ?> </th>
              <th> <?php echo e(__('Label.Participants User')); ?> </th>
              <th> <?php echo e(__('Label.Total Price')); ?> </th>
              <th> <?php echo e(__('Label.Winner')); ?> </th>
              <th> <?php echo e(__('Label.Action')); ?> </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
  <script type="text/javascript">
    $(document).ready(function() {
      $(function () {
        var table = $('.contest-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' >",
              next: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' style='transform: rotate(180deg)'>"
            }
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          ajax: "<?php echo e(route('contestData')); ?>",
          columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name', name:'name'},
            {data: 'start_date', name: 'start_date'},
            {data: 'end_date', name: 'end_date'},
            {data: 'price', name: 'price'}, 
            {data: 'no_of_user', name: 'no_of_user'}, 
            { data: 'total_participants_user', name: 'total_participants_user', 
              "render": function (data, type, full, meta) {
                if(data){
                  return data;
                } else {
                  return 0;
                }
              },
            },      
            {data: 'total_prize', name: 'total_prize'}, 
            {data: 'winner', name: 'winner'}, 
            {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
  
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\envato\app\dtquiz_backend\resources\views/admin/contest_list/index.blade.php ENDPATH**/ ?>